/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.functions.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.functions.aggregation.SumAggregator;
import org.apache.flink.streaming.api.functions.windowing.AllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.FoldAllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ReduceAllWindowFunction;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.EvictingNonKeyedWindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.NonKeyedWindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.buffers.HeapWindowBuffer;
import org.apache.flink.streaming.runtime.operators.windowing.buffers.PreAggregatingHeapWindowBuffer;

public class AllWindowedStream<T, W extends Window> {
    private final DataStream<T> input;
    private final WindowAssigner<? super T, W> windowAssigner;
    private Trigger<? super T, ? super W> trigger;
    private Evictor<? super T, ? super W> evictor;

    public AllWindowedStream(DataStream<T> input, WindowAssigner<? super T, W> windowAssigner) {
        this.input = input;
        this.windowAssigner = windowAssigner;
        this.trigger = windowAssigner.getDefaultTrigger(input.getExecutionEnvironment());
    }

    public AllWindowedStream<T, W> trigger(Trigger<? super T, ? super W> trigger) {
        this.trigger = trigger;
        return this;
    }

    public AllWindowedStream<T, W> evictor(Evictor<? super T, ? super W> evictor) {
        this.evictor = evictor;
        return this;
    }

    public SingleOutputStreamOperator<T, ?> reduce(ReduceFunction<T> function) {
        function = this.input.getExecutionEnvironment().clean(function);
        String callLocation = Utils.getCallLocationName();
        String udfName = "Reduce at " + callLocation;
        SingleOutputStreamOperator<T, ?> result = this.createFastTimeOperatorIfValid((Function)function, (TypeInformation)this.input.getType(), udfName);
        if (result != null) {
            return result;
        }
        String opName = "NonParallelTriggerWindow(" + this.windowAssigner + ", " + this.trigger + ", " + udfName + ")";
        boolean setProcessingTime = this.input.getExecutionEnvironment().getStreamTimeCharacteristic() == TimeCharacteristic.ProcessingTime;
        NonKeyedWindowOperator operator = this.evictor != null ? new EvictingNonKeyedWindowOperator(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), new HeapWindowBuffer.Factory(), new ReduceAllWindowFunction(function), this.trigger, this.evictor).enableSetProcessingTime(setProcessingTime) : new NonKeyedWindowOperator(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), new PreAggregatingHeapWindowBuffer.Factory<T>(function), new ReduceAllWindowFunction(function), this.trigger).enableSetProcessingTime(setProcessingTime);
        return this.input.transform(opName, this.input.getType(), operator).setParallelism(1);
    }

    public <R> SingleOutputStreamOperator<R, ?> fold(R initialValue, FoldFunction<T, R> function) {
        function = this.input.getExecutionEnvironment().clean(function);
        TypeInformation resultType = TypeExtractor.getFoldReturnTypes(function, this.input.getType(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.apply(new FoldAllWindowFunction(initialValue, function), resultType);
    }

    public <R> SingleOutputStreamOperator<R, ?> fold(R initialValue, FoldFunction<T, R> function, TypeInformation<R> resultType) {
        function = this.input.getExecutionEnvironment().clean(function);
        return this.apply(new FoldAllWindowFunction(initialValue, function), resultType);
    }

    public <R> SingleOutputStreamOperator<R, ?> apply(AllWindowFunction<T, R, W> function) {
        TypeInformation<T> inType = this.input.getType();
        TypeInformation resultType = TypeExtractor.getUnaryOperatorReturnType(function, AllWindowFunction.class, (boolean)true, (boolean)true, inType, null, (boolean)false);
        return this.apply(function, resultType);
    }

    public <R> SingleOutputStreamOperator<R, ?> apply(AllWindowFunction<T, R, W> function, TypeInformation<R> resultType) {
        function = this.input.getExecutionEnvironment().clean(function);
        String callLocation = Utils.getCallLocationName();
        String udfName = "WindowApply at " + callLocation;
        SingleOutputStreamOperator<R, ?> result = this.createFastTimeOperatorIfValid(function, resultType, udfName);
        if (result != null) {
            return result;
        }
        String opName = "TriggerWindow(" + this.windowAssigner + ", " + this.trigger + ", " + udfName + ")";
        boolean setProcessingTime = this.input.getExecutionEnvironment().getStreamTimeCharacteristic() == TimeCharacteristic.ProcessingTime;
        NonKeyedWindowOperator operator = this.evictor != null ? new EvictingNonKeyedWindowOperator<T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), new HeapWindowBuffer.Factory(), function, this.trigger, this.evictor).enableSetProcessingTime(setProcessingTime) : new NonKeyedWindowOperator<T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), new HeapWindowBuffer.Factory(), function, this.trigger).enableSetProcessingTime(setProcessingTime);
        return this.input.transform(opName, resultType, operator).setParallelism(1);
    }

    public <R> SingleOutputStreamOperator<R, ?> apply(ReduceFunction<T> preAggregator, AllWindowFunction<T, R, W> function) {
        TypeInformation<T> inType = this.input.getType();
        TypeInformation resultType = TypeExtractor.getUnaryOperatorReturnType(function, AllWindowFunction.class, (boolean)true, (boolean)true, inType, null, (boolean)false);
        return this.apply(preAggregator, function, resultType);
    }

    public <R> SingleOutputStreamOperator<R, ?> apply(ReduceFunction<T> preAggregator, AllWindowFunction<T, R, W> function, TypeInformation<R> resultType) {
        function = this.input.getExecutionEnvironment().clean(function);
        preAggregator = this.input.getExecutionEnvironment().clean(preAggregator);
        String callLocation = Utils.getCallLocationName();
        String udfName = "WindowApply at " + callLocation;
        String opName = "TriggerWindow(" + this.windowAssigner + ", " + this.trigger + ", " + udfName + ")";
        boolean setProcessingTime = this.input.getExecutionEnvironment().getStreamTimeCharacteristic() == TimeCharacteristic.ProcessingTime;
        NonKeyedWindowOperator operator = this.evictor != null ? new EvictingNonKeyedWindowOperator<T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), new HeapWindowBuffer.Factory(), function, this.trigger, this.evictor).enableSetProcessingTime(setProcessingTime) : new NonKeyedWindowOperator<T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), new PreAggregatingHeapWindowBuffer.Factory<T>(preAggregator), function, this.trigger).enableSetProcessingTime(setProcessingTime);
        return this.input.transform(opName, resultType, operator).setParallelism(1);
    }

    public SingleOutputStreamOperator<T, ?> sum(int positionToSum) {
        return this.aggregate(new SumAggregator<T>(positionToSum, this.input.getType(), this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> sum(String field) {
        return this.aggregate(new SumAggregator<T>(field, this.input.getType(), this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> min(int positionToMin) {
        return this.aggregate(new ComparableAggregator<T>(positionToMin, this.input.getType(), AggregationFunction.AggregationType.MIN, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> min(String field) {
        return this.aggregate(new ComparableAggregator<T>(field, this.input.getType(), AggregationFunction.AggregationType.MIN, false, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> minBy(int positionToMinBy) {
        return this.minBy(positionToMinBy, true);
    }

    public SingleOutputStreamOperator<T, ?> minBy(String positionToMinBy) {
        return this.minBy(positionToMinBy, true);
    }

    public SingleOutputStreamOperator<T, ?> minBy(int positionToMinBy, boolean first) {
        return this.aggregate(new ComparableAggregator<T>(positionToMinBy, this.input.getType(), AggregationFunction.AggregationType.MINBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> minBy(String field, boolean first) {
        return this.aggregate(new ComparableAggregator<T>(field, this.input.getType(), AggregationFunction.AggregationType.MINBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> max(int positionToMax) {
        return this.aggregate(new ComparableAggregator<T>(positionToMax, this.input.getType(), AggregationFunction.AggregationType.MAX, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> max(String field) {
        return this.aggregate(new ComparableAggregator<T>(field, this.input.getType(), AggregationFunction.AggregationType.MAX, false, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> maxBy(int positionToMaxBy) {
        return this.maxBy(positionToMaxBy, true);
    }

    public SingleOutputStreamOperator<T, ?> maxBy(String positionToMaxBy) {
        return this.maxBy(positionToMaxBy, true);
    }

    public SingleOutputStreamOperator<T, ?> maxBy(int positionToMaxBy, boolean first) {
        return this.aggregate(new ComparableAggregator<T>(positionToMaxBy, this.input.getType(), AggregationFunction.AggregationType.MAXBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> maxBy(String field, boolean first) {
        return this.aggregate(new ComparableAggregator<T>(field, this.input.getType(), AggregationFunction.AggregationType.MAXBY, first, this.input.getExecutionConfig()));
    }

    private SingleOutputStreamOperator<T, ?> aggregate(AggregationFunction<T> aggregator) {
        return this.reduce((ReduceFunction<T>)aggregator);
    }

    private <R> SingleOutputStreamOperator<R, ?> createFastTimeOperatorIfValid(Function function, TypeInformation<R> resultType, String functionName) {
        return null;
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.input.getExecutionEnvironment();
    }

    public TypeInformation<T> getInputType() {
        return this.input.getType();
    }
}

