/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.client.program.ContextEnvironment;
import org.apache.flink.client.program.DetachedEnvironment;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.optimizer.plan.FlinkPlan;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class StreamContextEnvironment
extends StreamExecutionEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(StreamContextEnvironment.class);
    private final ContextEnvironment ctx;

    protected StreamContextEnvironment(ContextEnvironment ctx) {
        this.ctx = ctx;
        if (ctx.getParallelism() > 0) {
            this.setParallelism(ctx.getParallelism());
        } else {
            this.setParallelism(GlobalConfiguration.getInteger((String)"parallelism.default", (int)1));
        }
    }

    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        Preconditions.checkNotNull((Object)"Streaming Job name should not be null.");
        StreamGraph streamGraph = this.getStreamGraph();
        streamGraph.setJobName(jobName);
        this.transformations.clear();
        if (this.ctx instanceof DetachedEnvironment) {
            LOG.warn("Job was executed in detached mode, the results will be available on completion.");
            ((DetachedEnvironment)this.ctx).setDetachedPlan((FlinkPlan)streamGraph);
            return DetachedEnvironment.DetachedJobExecutionResult.INSTANCE;
        }
        return this.ctx.getClient().run((FlinkPlan)streamGraph, this.ctx.getJars(), this.ctx.getClasspaths(), this.ctx.getUserCodeClassLoader(), this.ctx.getSavepointRestoreSettings()).getJobExecutionResult();
    }
}

