/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.util.Objects;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeInfoParser;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.api.transformations.StreamTransformation;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;

@Public
public class SingleOutputStreamOperator<T>
extends DataStream<T> {
    protected SingleOutputStreamOperator(StreamExecutionEnvironment environment, StreamTransformation<T> transformation) {
        super(environment, transformation);
    }

    public String getName() {
        return this.transformation.getName();
    }

    public SingleOutputStreamOperator<T> name(String name) {
        this.transformation.setName(name);
        return this;
    }

    @PublicEvolving
    public SingleOutputStreamOperator<T> uid(String uid) {
        this.transformation.setUid(uid);
        return this;
    }

    public SingleOutputStreamOperator<T> setParallelism(int parallelism) {
        if (parallelism < 1) {
            throw new IllegalArgumentException("The parallelism of an operator must be at least 1.");
        }
        this.transformation.setParallelism(parallelism);
        return this;
    }

    public SingleOutputStreamOperator<T> setBufferTimeout(long timeoutMillis) {
        this.transformation.setBufferTimeout(timeoutMillis);
        return this;
    }

    @PublicEvolving
    private SingleOutputStreamOperator<T> setChainingStrategy(ChainingStrategy strategy) {
        this.transformation.setChainingStrategy(strategy);
        return this;
    }

    @PublicEvolving
    public SingleOutputStreamOperator<T> disableChaining() {
        return this.setChainingStrategy(ChainingStrategy.NEVER);
    }

    @PublicEvolving
    public SingleOutputStreamOperator<T> startNewChain() {
        return this.setChainingStrategy(ChainingStrategy.HEAD);
    }

    public SingleOutputStreamOperator<T> returns(Class<T> typeClass) {
        Objects.requireNonNull(typeClass, "type class must not be null.");
        try {
            return this.returns(TypeInformation.of(typeClass));
        }
        catch (InvalidTypesException e) {
            throw new InvalidTypesException("Cannot infer the type information from the class alone.This is most likely because the class represents a generic type. In that case,please use the 'returns(TypeHint)' method instead.");
        }
    }

    public SingleOutputStreamOperator<T> returns(TypeHint<T> typeHint) {
        Objects.requireNonNull(typeHint, "TypeHint must not be null");
        try {
            return this.returns(TypeInformation.of(typeHint));
        }
        catch (InvalidTypesException e) {
            throw new InvalidTypesException("Cannot infer the type information from the type hint. Make sure that the TypeHint does not use any generic type variables.");
        }
    }

    public SingleOutputStreamOperator<T> returns(TypeInformation<T> typeInfo) {
        Objects.requireNonNull(typeInfo, "TypeInformation must not be null");
        this.transformation.setOutputType(typeInfo);
        return this;
    }

    @Deprecated
    @PublicEvolving
    public SingleOutputStreamOperator<T> returns(String typeInfoString) {
        if (typeInfoString == null) {
            throw new IllegalArgumentException("Type information string must not be null.");
        }
        return this.returns(TypeInfoParser.parse((String)typeInfoString));
    }

    @Override
    protected DataStream<T> setConnectionType(StreamPartitioner<T> partitioner) {
        return new SingleOutputStreamOperator(this.getExecutionEnvironment(), new PartitionTransformation(this.getTransformation(), partitioner));
    }

    @PublicEvolving
    public SingleOutputStreamOperator<T> slotSharingGroup(String slotSharingGroup) {
        this.transformation.setSlotSharingGroup(slotSharingGroup);
        return this;
    }
}

