/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.TimeServiceProvider;

public class DefaultTimeServiceProvider
extends TimeServiceProvider {
    private final ScheduledExecutorService timerService;

    public static DefaultTimeServiceProvider create(ScheduledExecutorService executor) {
        return new DefaultTimeServiceProvider(executor);
    }

    private DefaultTimeServiceProvider(ScheduledExecutorService threadPoolExecutor) {
        this.timerService = threadPoolExecutor;
    }

    @Override
    public long getCurrentProcessingTime() {
        return System.currentTimeMillis();
    }

    @Override
    public ScheduledFuture<?> registerTimer(long timestamp, Runnable target) {
        long delay = Math.max(timestamp - this.getCurrentProcessingTime(), 0L);
        return this.timerService.schedule(target, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdownService() throws Exception {
        if (!this.timerService.isTerminated()) {
            StreamTask.LOG.info("Timer service is shutting down.");
        }
        this.timerService.shutdownNow();
    }
}

