/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergingWindowSet<W extends Window> {
    private static final Logger LOG = LoggerFactory.getLogger(MergingWindowSet.class);
    private final Map<W, W> windows;
    private final MergingWindowAssigner<?, W> windowAssigner;

    public MergingWindowSet(MergingWindowAssigner<?, W> windowAssigner) {
        this.windowAssigner = windowAssigner;
        this.windows = new HashMap<W, W>();
    }

    public MergingWindowSet(MergingWindowAssigner<?, W> windowAssigner, ListState<Tuple2<W, W>> state) throws Exception {
        this.windowAssigner = windowAssigner;
        this.windows = new HashMap<W, W>();
        Iterable windowState = (Iterable)state.get();
        if (windowState != null) {
            for (Tuple2 window : windowState) {
                this.windows.put(window.f0, window.f1);
            }
        }
    }

    public void persist(ListState<Tuple2<W, W>> state) throws Exception {
        for (Map.Entry<W, W> window : this.windows.entrySet()) {
            state.add((Object)new Tuple2(window.getKey(), window.getValue()));
        }
    }

    public W getStateWindow(W window) {
        return (W)((Window)this.windows.get(window));
    }

    public void retireWindow(W window) {
        Window removed = (Window)this.windows.remove(window);
        if (removed == null) {
            throw new IllegalStateException("Window " + window + " is not in in-flight window set.");
        }
    }

    public W addWindow(W newWindow, MergeFunction<W> mergeFunction) throws Exception {
        ArrayList<W> windows = new ArrayList<W>();
        windows.addAll(this.windows.keySet());
        windows.add(newWindow);
        final HashMap mergeResults = new HashMap();
        this.windowAssigner.mergeWindows(windows, new MergingWindowAssigner.MergeCallback<W>(){

            @Override
            public void merge(Collection<W> toBeMerged, W mergeResult) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Merging {} into {}", toBeMerged, mergeResult);
                }
                mergeResults.put(mergeResult, toBeMerged);
            }
        });
        Object resultWindow = newWindow;
        for (Map.Entry c : mergeResults.entrySet()) {
            Window mergeResult = (Window)c.getKey();
            Collection mergedWindows = (Collection)c.getValue();
            if (mergedWindows.remove(newWindow)) {
                resultWindow = mergeResult;
            }
            Window mergedStateWindow = (Window)this.windows.get(mergedWindows.iterator().next());
            ArrayList<Window> mergedStateWindows = new ArrayList<Window>();
            for (Window mergedWindow : mergedWindows) {
                Window res = (Window)this.windows.remove(mergedWindow);
                if (res == null) continue;
                mergedStateWindows.add(res);
            }
            this.windows.put(mergeResult, mergedStateWindow);
            mergedStateWindows.remove(mergedStateWindow);
            if (mergedWindows.contains(mergeResult) && mergedWindows.size() == 1) continue;
            mergeFunction.merge(mergeResult, mergedWindows, (Window)this.windows.get(mergeResult), (Collection<Window>)mergedStateWindows);
        }
        if (resultWindow.equals(newWindow)) {
            this.windows.put(resultWindow, resultWindow);
        }
        return resultWindow;
    }

    public static interface MergeFunction<W> {
        public void merge(W var1, Collection<W> var2, W var3, Collection<W> var4) throws Exception;
    }
}

