/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.ScheduledFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.operators.Triggerable;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class StreamSource<OUT, SRC extends SourceFunction<OUT>>
extends AbstractUdfStreamOperator<OUT, SRC>
implements StreamOperator<OUT> {
    private static final long serialVersionUID = 1L;
    private transient SourceFunction.SourceContext<OUT> ctx;
    private volatile transient boolean canceledOrStopped = false;

    public StreamSource(SRC sourceFunction) {
        super(sourceFunction);
        this.chainingStrategy = ChainingStrategy.HEAD;
    }

    public void run(Object lockingObject) throws Exception {
        this.run(lockingObject, this.output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Object lockingObject, Output<StreamRecord<OUT>> collector) throws Exception {
        SourceFunction.SourceContext ctx;
        TimeCharacteristic timeCharacteristic = this.getOperatorConfig().getTimeCharacteristic();
        switch (timeCharacteristic) {
            case EventTime: {
                ctx = new ManualWatermarkContext(this, lockingObject, collector);
                break;
            }
            case IngestionTime: {
                ctx = new AutomaticWatermarkContext(this, lockingObject, collector, this.getRuntimeContext().getExecutionConfig().getAutoWatermarkInterval());
                break;
            }
            case ProcessingTime: {
                ctx = new NonTimestampContext(this, lockingObject, collector);
                break;
            }
            default: {
                throw new Exception(String.valueOf((Object)timeCharacteristic));
            }
        }
        this.ctx = ctx;
        try {
            ((SourceFunction)this.userFunction).run(ctx);
            if (!this.isCanceledOrStopped()) {
                ctx.emitWatermark(Watermark.MAX_WATERMARK);
            }
        }
        finally {
            ctx.close();
        }
    }

    public void cancel() {
        this.markCanceledOrStopped();
        ((SourceFunction)this.userFunction).cancel();
        if (this.ctx != null) {
            this.ctx.close();
        }
    }

    protected void markCanceledOrStopped() {
        this.canceledOrStopped = true;
    }

    protected boolean isCanceledOrStopped() {
        return this.canceledOrStopped;
    }

    void checkAsyncException() {
        this.getContainingTask().checkTimerException();
    }

    public static class ManualWatermarkContext<T>
    implements SourceFunction.SourceContext<T> {
        private final StreamSource<?, ?> owner;
        private final Object lockingObject;
        private final Output<StreamRecord<T>> output;
        private final StreamRecord<T> reuse;

        public ManualWatermarkContext(StreamSource<?, ?> owner, Object lockingObject, Output<StreamRecord<T>> output) {
            this.owner = owner;
            this.lockingObject = lockingObject;
            this.output = output;
            this.reuse = new StreamRecord<Object>(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void collect(T element) {
            this.owner.checkAsyncException();
            Object object = this.lockingObject;
            synchronized (object) {
                this.output.collect(this.reuse.replace(element));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void collectWithTimestamp(T element, long timestamp) {
            this.owner.checkAsyncException();
            Object object = this.lockingObject;
            synchronized (object) {
                this.output.collect(this.reuse.replace(element, timestamp));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void emitWatermark(Watermark mark) {
            this.owner.checkAsyncException();
            Object object = this.lockingObject;
            synchronized (object) {
                this.output.emitWatermark(mark);
            }
        }

        @Override
        public Object getCheckpointLock() {
            return this.lockingObject;
        }

        @Override
        public void close() {
        }
    }

    public static class AutomaticWatermarkContext<T>
    implements SourceFunction.SourceContext<T> {
        private final StreamSource<?, ?> owner;
        private final Object lockingObject;
        private final Output<StreamRecord<T>> output;
        private final StreamRecord<T> reuse;
        private final ScheduledFuture<?> watermarkTimer;
        private final long watermarkInterval;
        private volatile long nextWatermarkTime;

        public AutomaticWatermarkContext(StreamSource<?, ?> owner, Object lockingObjectParam, Output<StreamRecord<T>> outputParam, long watermarkInterval) {
            if (watermarkInterval < 1L) {
                throw new IllegalArgumentException("The watermark interval cannot be smaller than one.");
            }
            this.owner = owner;
            this.lockingObject = lockingObjectParam;
            this.output = outputParam;
            this.watermarkInterval = watermarkInterval;
            this.reuse = new StreamRecord<Object>(null);
            long now = owner.getCurrentProcessingTime();
            this.watermarkTimer = owner.registerTimer(now + watermarkInterval, new WatermarkEmittingTask(owner, lockingObjectParam, outputParam));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void collect(T element) {
            this.owner.checkAsyncException();
            Object object = this.lockingObject;
            synchronized (object) {
                long currentTime = this.owner.getCurrentProcessingTime();
                this.output.collect(this.reuse.replace(element, currentTime));
                if (currentTime > this.nextWatermarkTime) {
                    long watermarkTime = currentTime - currentTime % this.watermarkInterval;
                    this.nextWatermarkTime = watermarkTime + this.watermarkInterval;
                    this.output.emitWatermark(new Watermark(watermarkTime));
                }
            }
        }

        @Override
        public void collectWithTimestamp(T element, long timestamp) {
            this.collect(element);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void emitWatermark(Watermark mark) {
            this.owner.checkAsyncException();
            if (mark.getTimestamp() == Long.MAX_VALUE) {
                Object object = this.lockingObject;
                synchronized (object) {
                    this.nextWatermarkTime = Long.MAX_VALUE;
                    this.output.emitWatermark(mark);
                }
                this.watermarkTimer.cancel(true);
            }
        }

        @Override
        public Object getCheckpointLock() {
            return this.lockingObject;
        }

        @Override
        public void close() {
            this.watermarkTimer.cancel(true);
        }

        private class WatermarkEmittingTask
        implements Triggerable {
            private final StreamSource<?, ?> owner;
            private final Object lockingObject;
            private final Output<StreamRecord<T>> output;

            private WatermarkEmittingTask(StreamSource<?, ?> src, Object lock, Output<StreamRecord<T>> output) {
                this.owner = src;
                this.lockingObject = lock;
                this.output = output;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void trigger(long timestamp) {
                long currentTime = this.owner.getCurrentProcessingTime();
                if (currentTime > AutomaticWatermarkContext.this.nextWatermarkTime) {
                    long watermarkTime = currentTime - currentTime % AutomaticWatermarkContext.this.watermarkInterval;
                    Object object = this.lockingObject;
                    synchronized (object) {
                        if (currentTime > AutomaticWatermarkContext.this.nextWatermarkTime) {
                            this.output.emitWatermark(new Watermark(watermarkTime));
                            AutomaticWatermarkContext.this.nextWatermarkTime = AutomaticWatermarkContext.this.nextWatermarkTime + AutomaticWatermarkContext.this.watermarkInterval;
                        }
                    }
                }
                this.owner.registerTimer(this.owner.getCurrentProcessingTime() + AutomaticWatermarkContext.this.watermarkInterval, new WatermarkEmittingTask(this.owner, this.lockingObject, this.output));
            }
        }
    }

    public static class NonTimestampContext<T>
    implements SourceFunction.SourceContext<T> {
        private final StreamSource<?, ?> owner;
        private final Object lockingObject;
        private final Output<StreamRecord<T>> output;
        private final StreamRecord<T> reuse;

        public NonTimestampContext(StreamSource<?, ?> owner, Object lockingObject, Output<StreamRecord<T>> output) {
            this.owner = owner;
            this.lockingObject = lockingObject;
            this.output = output;
            this.reuse = new StreamRecord<Object>(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void collect(T element) {
            this.owner.checkAsyncException();
            Object object = this.lockingObject;
            synchronized (object) {
                this.output.collect(this.reuse.replace(element));
            }
        }

        @Override
        public void collectWithTimestamp(T element, long timestamp) {
            this.collect(element);
        }

        @Override
        public void emitWatermark(Watermark mark) {
            this.owner.checkAsyncException();
        }

        @Override
        public Object getCheckpointLock() {
            return this.lockingObject;
        }

        @Override
        public void close() {
        }
    }
}

