/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.datastream.WindowedStream;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;

@Public
public class CoGroupedStreams<T1, T2> {
    private final DataStream<T1> input1;
    private final DataStream<T2> input2;

    public CoGroupedStreams(DataStream<T1> input1, DataStream<T2> input2) {
        this.input1 = Objects.requireNonNull(input1);
        this.input2 = Objects.requireNonNull(input2);
    }

    public <KEY> Where<KEY> where(KeySelector<T1, KEY> keySelector) {
        TypeInformation keyType = TypeExtractor.getKeySelectorTypes(keySelector, this.input1.getType());
        return new Where<KEY>(this.input1.clean(keySelector), keyType);
    }

    private static class CoGroupWindowFunction<T1, T2, T, KEY, W extends Window>
    extends WrappingFunction<CoGroupFunction<T1, T2, T>>
    implements WindowFunction<TaggedUnion<T1, T2>, T, KEY, W> {
        private static final long serialVersionUID = 1L;

        public CoGroupWindowFunction(CoGroupFunction<T1, T2, T> userFunction) {
            super(userFunction);
        }

        @Override
        public void apply(KEY key, W window, Iterable<TaggedUnion<T1, T2>> values, Collector<T> out) throws Exception {
            ArrayList<T1> oneValues = new ArrayList<T1>();
            ArrayList<T2> twoValues = new ArrayList<T2>();
            for (TaggedUnion<T1, T2> val : values) {
                if (val.isOne()) {
                    oneValues.add(val.getOne());
                    continue;
                }
                twoValues.add(val.getTwo());
            }
            ((CoGroupFunction)this.wrappedFunction).coGroup(oneValues, twoValues, out);
        }
    }

    private static class UnionKeySelector<T1, T2, KEY>
    implements KeySelector<TaggedUnion<T1, T2>, KEY> {
        private static final long serialVersionUID = 1L;
        private final KeySelector<T1, KEY> keySelector1;
        private final KeySelector<T2, KEY> keySelector2;

        public UnionKeySelector(KeySelector<T1, KEY> keySelector1, KeySelector<T2, KEY> keySelector2) {
            this.keySelector1 = keySelector1;
            this.keySelector2 = keySelector2;
        }

        public KEY getKey(TaggedUnion<T1, T2> value) throws Exception {
            if (value.isOne()) {
                return (KEY)this.keySelector1.getKey(value.getOne());
            }
            return (KEY)this.keySelector2.getKey(value.getTwo());
        }
    }

    private static class Input2Tagger<T1, T2>
    implements MapFunction<T2, TaggedUnion<T1, T2>> {
        private static final long serialVersionUID = 1L;

        private Input2Tagger() {
        }

        public TaggedUnion<T1, T2> map(T2 value) throws Exception {
            return TaggedUnion.two(value);
        }
    }

    private static class Input1Tagger<T1, T2>
    implements MapFunction<T1, TaggedUnion<T1, T2>> {
        private static final long serialVersionUID = 1L;

        private Input1Tagger() {
        }

        public TaggedUnion<T1, T2> map(T1 value) throws Exception {
            return TaggedUnion.one(value);
        }
    }

    private static class UnionSerializer<T1, T2>
    extends TypeSerializer<TaggedUnion<T1, T2>> {
        private static final long serialVersionUID = 1L;
        private final TypeSerializer<T1> oneSerializer;
        private final TypeSerializer<T2> twoSerializer;

        public UnionSerializer(TypeSerializer<T1> oneSerializer, TypeSerializer<T2> twoSerializer) {
            this.oneSerializer = oneSerializer;
            this.twoSerializer = twoSerializer;
        }

        public boolean isImmutableType() {
            return false;
        }

        public TypeSerializer<TaggedUnion<T1, T2>> duplicate() {
            return this;
        }

        public TaggedUnion<T1, T2> createInstance() {
            return null;
        }

        public TaggedUnion<T1, T2> copy(TaggedUnion<T1, T2> from) {
            if (from.isOne()) {
                return TaggedUnion.one(this.oneSerializer.copy(from.getOne()));
            }
            return TaggedUnion.two(this.twoSerializer.copy(from.getTwo()));
        }

        public TaggedUnion<T1, T2> copy(TaggedUnion<T1, T2> from, TaggedUnion<T1, T2> reuse) {
            if (from.isOne()) {
                return TaggedUnion.one(this.oneSerializer.copy(from.getOne()));
            }
            return TaggedUnion.two(this.twoSerializer.copy(from.getTwo()));
        }

        public int getLength() {
            return -1;
        }

        public void serialize(TaggedUnion<T1, T2> record, DataOutputView target) throws IOException {
            if (record.isOne()) {
                target.writeByte(1);
                this.oneSerializer.serialize(record.getOne(), target);
            } else {
                target.writeByte(2);
                this.twoSerializer.serialize(record.getTwo(), target);
            }
        }

        public TaggedUnion<T1, T2> deserialize(DataInputView source) throws IOException {
            byte tag = source.readByte();
            if (tag == 1) {
                return TaggedUnion.one(this.oneSerializer.deserialize(source));
            }
            return TaggedUnion.two(this.twoSerializer.deserialize(source));
        }

        public TaggedUnion<T1, T2> deserialize(TaggedUnion<T1, T2> reuse, DataInputView source) throws IOException {
            byte tag = source.readByte();
            if (tag == 1) {
                return TaggedUnion.one(this.oneSerializer.deserialize(source));
            }
            return TaggedUnion.two(this.twoSerializer.deserialize(source));
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            byte tag = source.readByte();
            target.writeByte((int)tag);
            if (tag == 1) {
                this.oneSerializer.copy(source, target);
            } else {
                this.twoSerializer.copy(source, target);
            }
        }

        public int hashCode() {
            return 31 * this.oneSerializer.hashCode() + this.twoSerializer.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof UnionSerializer) {
                UnionSerializer other = (UnionSerializer)((Object)obj);
                return other.canEqual((Object)this) && this.oneSerializer.equals(other.oneSerializer) && this.twoSerializer.equals(other.twoSerializer);
            }
            return false;
        }

        public boolean canEqual(Object obj) {
            return obj instanceof UnionSerializer;
        }
    }

    private static class UnionTypeInfo<T1, T2>
    extends TypeInformation<TaggedUnion<T1, T2>> {
        private static final long serialVersionUID = 1L;
        private final TypeInformation<T1> oneType;
        private final TypeInformation<T2> twoType;

        public UnionTypeInfo(TypeInformation<T1> oneType, TypeInformation<T2> twoType) {
            this.oneType = oneType;
            this.twoType = twoType;
        }

        public boolean isBasicType() {
            return false;
        }

        public boolean isTupleType() {
            return false;
        }

        public int getArity() {
            return 2;
        }

        public int getTotalFields() {
            return 2;
        }

        public Class<TaggedUnion<T1, T2>> getTypeClass() {
            return TaggedUnion.class;
        }

        public boolean isKeyType() {
            return true;
        }

        public TypeSerializer<TaggedUnion<T1, T2>> createSerializer(ExecutionConfig config) {
            return new UnionSerializer(this.oneType.createSerializer(config), this.twoType.createSerializer(config));
        }

        public String toString() {
            return "TaggedUnion<" + this.oneType + ", " + this.twoType + ">";
        }

        public boolean equals(Object obj) {
            if (obj instanceof UnionTypeInfo) {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)((Object)obj);
                return unionTypeInfo.canEqual((Object)this) && this.oneType.equals(unionTypeInfo.oneType) && this.twoType.equals(unionTypeInfo.twoType);
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.oneType.hashCode() + this.twoType.hashCode();
        }

        public boolean canEqual(Object obj) {
            return obj instanceof UnionTypeInfo;
        }
    }

    @Internal
    public static class TaggedUnion<T1, T2> {
        private final T1 one;
        private final T2 two;

        private TaggedUnion(T1 one, T2 two) {
            this.one = one;
            this.two = two;
        }

        public boolean isOne() {
            return this.one != null;
        }

        public boolean isTwo() {
            return this.two != null;
        }

        public T1 getOne() {
            return this.one;
        }

        public T2 getTwo() {
            return this.two;
        }

        public static <T1, T2> TaggedUnion<T1, T2> one(T1 one) {
            return new TaggedUnion<T1, Object>(one, null);
        }

        public static <T1, T2> TaggedUnion<T1, T2> two(T2 two) {
            return new TaggedUnion<Object, T2>(null, two);
        }
    }

    @Public
    public static class WithWindow<T1, T2, KEY, W extends Window> {
        private final DataStream<T1> input1;
        private final DataStream<T2> input2;
        private final KeySelector<T1, KEY> keySelector1;
        private final KeySelector<T2, KEY> keySelector2;
        private final TypeInformation<KEY> keyType;
        private final WindowAssigner<? super TaggedUnion<T1, T2>, W> windowAssigner;
        private final Trigger<? super TaggedUnion<T1, T2>, ? super W> trigger;
        private final Evictor<? super TaggedUnion<T1, T2>, ? super W> evictor;

        protected WithWindow(DataStream<T1> input1, DataStream<T2> input2, KeySelector<T1, KEY> keySelector1, KeySelector<T2, KEY> keySelector2, TypeInformation<KEY> keyType, WindowAssigner<? super TaggedUnion<T1, T2>, W> windowAssigner, Trigger<? super TaggedUnion<T1, T2>, ? super W> trigger, Evictor<? super TaggedUnion<T1, T2>, ? super W> evictor) {
            this.input1 = input1;
            this.input2 = input2;
            this.keySelector1 = keySelector1;
            this.keySelector2 = keySelector2;
            this.keyType = keyType;
            this.windowAssigner = windowAssigner;
            this.trigger = trigger;
            this.evictor = evictor;
        }

        @PublicEvolving
        public WithWindow<T1, T2, KEY, W> trigger(Trigger<? super TaggedUnion<T1, T2>, ? super W> newTrigger) {
            return new WithWindow<T1, T2, KEY, W>(this.input1, this.input2, this.keySelector1, this.keySelector2, this.keyType, this.windowAssigner, newTrigger, this.evictor);
        }

        @PublicEvolving
        public WithWindow<T1, T2, KEY, W> evictor(Evictor<? super TaggedUnion<T1, T2>, ? super W> newEvictor) {
            return new WithWindow<T1, T2, KEY, W>(this.input1, this.input2, this.keySelector1, this.keySelector2, this.keyType, this.windowAssigner, this.trigger, newEvictor);
        }

        public <T> DataStream<T> apply(CoGroupFunction<T1, T2, T> function) {
            TypeInformation resultType = TypeExtractor.getBinaryOperatorReturnType(function, CoGroupFunction.class, (boolean)true, (boolean)true, this.input1.getType(), this.input2.getType(), (String)"CoGroup", (boolean)false);
            return this.apply(function, resultType);
        }

        public <T> DataStream<T> apply(CoGroupFunction<T1, T2, T> function, TypeInformation<T> resultType) {
            function = this.input1.getExecutionEnvironment().clean(function);
            UnionTypeInfo<T1, T2> unionType = new UnionTypeInfo<T1, T2>(this.input1.getType(), this.input2.getType());
            UnionKeySelector<T1, T2, KEY> unionKeySelector = new UnionKeySelector<T1, T2, KEY>(this.keySelector1, this.keySelector2);
            SingleOutputStreamOperator taggedInput1 = this.input1.map(new Input1Tagger()).returns(unionType);
            SingleOutputStreamOperator taggedInput2 = this.input2.map(new Input2Tagger()).returns(unionType);
            DataStream unionStream = taggedInput1.union(taggedInput2);
            WindowedStream<TaggedUnion<T1, T2>, KEY, Object> windowOp = new KeyedStream<TaggedUnion<T1, T2>, KEY>(unionStream, unionKeySelector, this.keyType).window(this.windowAssigner);
            if (this.trigger != null) {
                windowOp.trigger(this.trigger);
            }
            if (this.evictor != null) {
                windowOp.evictor(this.evictor);
            }
            return windowOp.apply(new CoGroupWindowFunction(function), resultType);
        }
    }

    @Public
    public class Where<KEY> {
        private final KeySelector<T1, KEY> keySelector1;
        private final TypeInformation<KEY> keyType;

        Where(KeySelector<T1, KEY> keySelector1, TypeInformation<KEY> keyType) {
            this.keySelector1 = keySelector1;
            this.keyType = keyType;
        }

        public EqualTo equalTo(KeySelector<T2, KEY> keySelector) {
            TypeInformation otherKey = TypeExtractor.getKeySelectorTypes(keySelector, CoGroupedStreams.this.input2.getType());
            if (!otherKey.equals(this.keyType)) {
                throw new IllegalArgumentException("The keys for the two inputs are not equal: first key = " + this.keyType + " , second key = " + otherKey);
            }
            return new EqualTo(CoGroupedStreams.this.input2.clean(keySelector));
        }

        @Public
        public class EqualTo {
            private final KeySelector<T2, KEY> keySelector2;

            EqualTo(KeySelector<T2, KEY> keySelector2) {
                this.keySelector2 = Objects.requireNonNull(keySelector2);
            }

            @PublicEvolving
            public <W extends Window> WithWindow<T1, T2, KEY, W> window(WindowAssigner<? super TaggedUnion<T1, T2>, W> assigner) {
                return new WithWindow(CoGroupedStreams.this.input1, CoGroupedStreams.this.input2, Where.this.keySelector1, this.keySelector2, Where.this.keyType, assigner, null, null);
            }
        }
    }
}

