/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.util.ArrayDeque;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.util.event.EventListener;
import org.apache.flink.streaming.runtime.io.BufferSpiller;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class BarrierBuffer
implements CheckpointBarrierHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BarrierBuffer.class);
    private final InputGate inputGate;
    private final boolean[] blockedChannels;
    private final int totalNumberOfInputChannels;
    private final BufferSpiller bufferSpiller;
    private final ArrayDeque<BufferSpiller.SpilledBufferOrEventSequence> queuedBuffered;
    private BufferSpiller.SpilledBufferOrEventSequence currentBuffered;
    private EventListener<CheckpointBarrier> checkpointHandler;
    private long currentCheckpointId = -1L;
    private int numBarriersReceived;
    private int numClosedChannels;
    private boolean endOfStream;

    public BarrierBuffer(InputGate inputGate, IOManager ioManager) throws IOException {
        this.inputGate = inputGate;
        this.totalNumberOfInputChannels = inputGate.getNumberOfInputChannels();
        this.blockedChannels = new boolean[this.totalNumberOfInputChannels];
        this.bufferSpiller = new BufferSpiller(ioManager, inputGate.getPageSize());
        this.queuedBuffered = new ArrayDeque();
    }

    @Override
    public BufferOrEvent getNextNonBlocked() throws IOException, InterruptedException {
        block8: {
            BufferOrEvent next;
            while (true) {
                if (this.currentBuffered == null) {
                    next = this.inputGate.getNextBufferOrEvent();
                } else {
                    next = this.currentBuffered.getNext();
                    if (next == null) {
                        this.completeBufferedSequence();
                        return this.getNextNonBlocked();
                    }
                }
                if (next == null) break block8;
                if (this.isBlocked(next.getChannelIndex())) {
                    this.bufferSpiller.add(next);
                    continue;
                }
                if (next.isBuffer()) {
                    return next;
                }
                if (next.getEvent().getClass() != CheckpointBarrier.class) break;
                if (this.endOfStream) continue;
                this.processBarrier((CheckpointBarrier)next.getEvent(), next.getChannelIndex());
            }
            if (next.getEvent().getClass() == EndOfPartitionEvent.class) {
                ++this.numClosedChannels;
                this.releaseBlocks();
            }
            return next;
        }
        if (!this.endOfStream) {
            this.endOfStream = true;
            this.releaseBlocks();
            return this.getNextNonBlocked();
        }
        return null;
    }

    private void completeBufferedSequence() throws IOException {
        this.currentBuffered.cleanup();
        this.currentBuffered = this.queuedBuffered.pollFirst();
        if (this.currentBuffered != null) {
            this.currentBuffered.open();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processBarrier(CheckpointBarrier receivedBarrier, int channelIndex) throws IOException {
        long barrierId = receivedBarrier.getId();
        if (this.numBarriersReceived > 0) {
            if (barrierId == this.currentCheckpointId) {
                this.onBarrier(channelIndex);
            } else {
                if (barrierId <= this.currentCheckpointId) return;
                LOG.warn("Received checkpoint barrier for checkpoint {} before completing current checkpoint {}. Skipping current checkpoint.", (Object)barrierId, (Object)this.currentCheckpointId);
                this.releaseBlocks();
                this.currentCheckpointId = barrierId;
                this.onBarrier(channelIndex);
            }
        } else {
            if (barrierId <= this.currentCheckpointId) return;
            this.currentCheckpointId = barrierId;
            this.onBarrier(channelIndex);
        }
        if (this.numBarriersReceived + this.numClosedChannels != this.totalNumberOfInputChannels) return;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received all barrier, triggering checkpoint {} at {}", (Object)receivedBarrier.getId(), (Object)receivedBarrier.getTimestamp());
        }
        if (this.checkpointHandler != null) {
            this.checkpointHandler.onEvent((Object)receivedBarrier);
        }
        this.releaseBlocks();
    }

    @Override
    public void registerCheckpointEventHandler(EventListener<CheckpointBarrier> checkpointHandler) {
        if (this.checkpointHandler != null) {
            throw new IllegalStateException("BarrierBuffer already has a registered checkpoint handler");
        }
        this.checkpointHandler = checkpointHandler;
    }

    @Override
    public boolean isEmpty() {
        return this.currentBuffered == null;
    }

    @Override
    public void cleanup() throws IOException {
        this.bufferSpiller.close();
        if (this.currentBuffered != null) {
            this.currentBuffered.cleanup();
        }
        for (BufferSpiller.SpilledBufferOrEventSequence seq : this.queuedBuffered) {
            seq.cleanup();
        }
    }

    private boolean isBlocked(int channelIndex) {
        return this.blockedChannels[channelIndex];
    }

    private void onBarrier(int channelIndex) throws IOException {
        if (!this.blockedChannels[channelIndex]) {
            this.blockedChannels[channelIndex] = true;
            ++this.numBarriersReceived;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received barrier from channel " + channelIndex);
            }
        } else {
            throw new IOException("Stream corrupt: Repeated barrier for same checkpoint and input stream");
        }
    }

    private void releaseBlocks() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Releasing blocks");
        }
        for (int i = 0; i < this.blockedChannels.length; ++i) {
            this.blockedChannels[i] = false;
        }
        this.numBarriersReceived = 0;
        if (this.currentBuffered == null) {
            this.currentBuffered = this.bufferSpiller.rollOver();
            if (this.currentBuffered != null) {
                this.currentBuffered.open();
            }
        } else {
            BufferSpiller.SpilledBufferOrEventSequence bufferedNow = this.bufferSpiller.rollOverWithNewBuffer();
            if (bufferedNow != null) {
                bufferedNow.open();
                this.queuedBuffered.addFirst(this.currentBuffered);
                this.currentBuffered = bufferedNow;
            }
        }
    }

    public long getCurrentCheckpointId() {
        return this.currentCheckpointId;
    }

    public String toString() {
        return String.format("last checkpoint: %d, current barriers: %d, closed channels: %d", this.currentCheckpointId, this.numBarriersReceived, this.numClosedChannels);
    }
}

