/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.triggers;

public enum TriggerResult {
    CONTINUE(false, false),
    FIRE_AND_PURGE(true, true),
    FIRE(true, false),
    PURGE(false, true);

    private final boolean fire;
    private final boolean purge;

    private TriggerResult(boolean fire, boolean purge) {
        this.purge = purge;
        this.fire = fire;
    }

    public boolean isFire() {
        return this.fire;
    }

    public boolean isPurge() {
        return this.purge;
    }

    public static TriggerResult merge(TriggerResult a, TriggerResult b) {
        if (a.purge || b.purge) {
            if (a.fire || b.fire) {
                return FIRE_AND_PURGE;
            }
            return PURGE;
        }
        if (a.fire || b.fire) {
            return FIRE;
        }
        return CONTINUE;
    }
}

