/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.shaded.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.transformations.StreamTransformation;

@Internal
public class TwoInputTransformation<IN1, IN2, OUT>
extends StreamTransformation<OUT> {
    private final StreamTransformation<IN1> input1;
    private final StreamTransformation<IN2> input2;
    private final TwoInputStreamOperator<IN1, IN2, OUT> operator;
    private KeySelector<IN1, ?> stateKeySelector1;
    private KeySelector<IN2, ?> stateKeySelector2;
    private TypeInformation<?> stateKeyType;

    public TwoInputTransformation(StreamTransformation<IN1> input1, StreamTransformation<IN2> input2, String name, TwoInputStreamOperator<IN1, IN2, OUT> operator, TypeInformation<OUT> outputType, int parallelism) {
        super(name, outputType, parallelism);
        this.input1 = input1;
        this.input2 = input2;
        this.operator = operator;
    }

    public StreamTransformation<IN1> getInput1() {
        return this.input1;
    }

    public StreamTransformation<IN2> getInput2() {
        return this.input2;
    }

    public TypeInformation<IN1> getInputType1() {
        return this.input1.getOutputType();
    }

    public TypeInformation<IN2> getInputType2() {
        return this.input2.getOutputType();
    }

    public TwoInputStreamOperator<IN1, IN2, OUT> getOperator() {
        return this.operator;
    }

    public void setStateKeySelectors(KeySelector<IN1, ?> stateKeySelector1, KeySelector<IN2, ?> stateKeySelector2) {
        this.stateKeySelector1 = stateKeySelector1;
        this.stateKeySelector2 = stateKeySelector2;
    }

    public KeySelector<IN1, ?> getStateKeySelector1() {
        return this.stateKeySelector1;
    }

    public KeySelector<IN2, ?> getStateKeySelector2() {
        return this.stateKeySelector2;
    }

    public void setStateKeyType(TypeInformation<?> stateKeyType) {
        this.stateKeyType = stateKeyType;
    }

    public TypeInformation<?> getStateKeyType() {
        return this.stateKeyType;
    }

    @Override
    public Collection<StreamTransformation<?>> getTransitivePredecessors() {
        ArrayList<StreamTransformation<?>> result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input1.getTransitivePredecessors());
        result.addAll(this.input2.getTransitivePredecessors());
        return result;
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        this.operator.setChainingStrategy(strategy);
    }
}

