/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.StreamTransformation;

@Internal
public class SelectTransformation<T>
extends StreamTransformation<T> {
    private final StreamTransformation<T> input;
    private final List<String> selectedNames;

    public SelectTransformation(StreamTransformation<T> input, List<String> selectedNames) {
        super("Select", input.getOutputType(), input.getParallelism());
        this.input = input;
        this.selectedNames = selectedNames;
    }

    public StreamTransformation<T> getInput() {
        return this.input;
    }

    public List<String> getSelectedNames() {
        return this.selectedNames;
    }

    @Override
    public Collection<StreamTransformation<?>> getTransitivePredecessors() {
        ArrayList<StreamTransformation<?>> result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        throw new UnsupportedOperationException("Cannot set chaining strategy on Select Transformation.");
    }
}

