/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.windowing;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;

@Internal
public class ReduceIterableWindowFunction<K, W extends Window, T>
implements WindowFunction<T, T, K, W> {
    private static final long serialVersionUID = 1L;
    private final ReduceFunction<T> reduceFunction;

    public ReduceIterableWindowFunction(ReduceFunction<T> reduceFunction) {
        this.reduceFunction = reduceFunction;
    }

    @Override
    public void apply(K k, W window, Iterable<T> input, Collector<T> out) throws Exception {
        Object curr = null;
        for (T val : input) {
            if (curr == null) {
                curr = val;
                continue;
            }
            curr = this.reduceFunction.reduce(curr, val);
        }
        out.collect(curr);
    }
}

