/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.watermark.Watermark;

public class CollectingSourceContext<T extends Serializable>
implements SourceFunction.SourceContext<T> {
    private final Object lock;
    private final Collection<T> collection;

    public CollectingSourceContext(Object lock, Collection<T> collection) {
        this.lock = lock;
        this.collection = collection;
    }

    public void collect(T element) {
        try {
            this.collection.add(CommonTestUtils.createCopySerializable(element));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void collectWithTimestamp(T element, long timestamp) {
        this.collect(element);
    }

    public void emitWatermark(Watermark mark) {
        throw new UnsupportedOperationException();
    }

    public Object getCheckpointLock() {
        return this.lock;
    }

    public void close() {
    }
}

