/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.IOException;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.util.serialization.AbstractDeserializationSchema;
import org.codehaus.jackson.map.util.JSONPObject;
import org.junit.Assert;
import org.junit.Test;

public class AbstractDeserializationSchemaTest {
    @Test
    public void testTypeExtractionTuple() {
        TypeInformation type = new TupleSchema().getProducedType();
        TypeInformation expected = TypeInformation.of((TypeHint)new TypeHint<Tuple2<byte[], byte[]>>(){});
        Assert.assertEquals((Object)expected, (Object)type);
    }

    @Test
    public void testTypeExtractionTupleAnonymous() {
        TypeInformation type = new AbstractDeserializationSchema<Tuple2<byte[], byte[]>>(){

            public Tuple2<byte[], byte[]> deserialize(byte[] message) throws IOException {
                throw new UnsupportedOperationException();
            }
        }.getProducedType();
        TypeInformation expected = TypeInformation.of((TypeHint)new TypeHint<Tuple2<byte[], byte[]>>(){});
        Assert.assertEquals((Object)expected, (Object)type);
    }

    @Test
    public void testTypeExtractionGeneric() {
        TypeInformation type = new JsonSchema().getProducedType();
        TypeInformation expected = TypeInformation.of((TypeHint)new TypeHint<JSONPObject>(){});
        Assert.assertEquals((Object)expected, (Object)type);
    }

    @Test
    public void testTypeExtractionGenericAnonymous() {
        TypeInformation type = new AbstractDeserializationSchema<JSONPObject>(){

            public JSONPObject deserialize(byte[] message) throws IOException {
                throw new UnsupportedOperationException();
            }
        }.getProducedType();
        TypeInformation expected = TypeInformation.of((TypeHint)new TypeHint<JSONPObject>(){});
        Assert.assertEquals((Object)expected, (Object)type);
    }

    @Test
    public void testTypeExtractionRawException() {
        try {
            new RawSchema().getProducedType();
            Assert.fail();
        }
        catch (InvalidTypesException invalidTypesException) {
            // empty catch block
        }
    }

    private static class RawSchema
    extends AbstractDeserializationSchema {
        private RawSchema() {
        }

        public Object deserialize(byte[] message) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class JsonSchema
    extends AbstractDeserializationSchema<JSONPObject> {
        private JsonSchema() {
        }

        public JSONPObject deserialize(byte[] message) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class TupleSchema
    extends AbstractDeserializationSchema<Tuple2<byte[], byte[]>> {
        private TupleSchema() {
        }

        public Tuple2<byte[], byte[]> deserialize(byte[] message) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

