/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Future;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.api.serialization.AdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.operators.testutils.MockInputSplitProvider;
import org.apache.flink.runtime.operators.testutils.UnregisteredTaskMetricsGroup;
import org.apache.flink.runtime.plugable.NonReusingDeserializationDelegate;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class StreamMockEnvironment
implements Environment {
    private final TaskInfo taskInfo;
    private final MemoryManager memManager;
    private final IOManager ioManager;
    private final InputSplitProvider inputSplitProvider;
    private final Configuration jobConfiguration;
    private final Configuration taskConfiguration;
    private final List<InputGate> inputs;
    private final List<ResultPartitionWriter> outputs;
    private final JobID jobID = new JobID();
    private final BroadcastVariableManager bcVarManager = new BroadcastVariableManager();
    private final AccumulatorRegistry accumulatorRegistry;
    private final int bufferSize;
    private final ExecutionConfig executionConfig;

    public StreamMockEnvironment(Configuration jobConfig, Configuration taskConfig, ExecutionConfig executionConfig, long memorySize, MockInputSplitProvider inputSplitProvider, int bufferSize) {
        this.taskInfo = new TaskInfo("", 0, 1, 0);
        this.jobConfiguration = jobConfig;
        this.taskConfiguration = taskConfig;
        this.inputs = new LinkedList<InputGate>();
        this.outputs = new LinkedList<ResultPartitionWriter>();
        this.memManager = new MemoryManager(memorySize, 1);
        this.ioManager = new IOManagerAsync();
        this.inputSplitProvider = inputSplitProvider;
        this.bufferSize = bufferSize;
        this.executionConfig = executionConfig;
        this.accumulatorRegistry = new AccumulatorRegistry(this.jobID, this.getExecutionId());
    }

    public StreamMockEnvironment(Configuration jobConfig, Configuration taskConfig, long memorySize, MockInputSplitProvider inputSplitProvider, int bufferSize) {
        this(jobConfig, taskConfig, null, memorySize, inputSplitProvider, bufferSize);
    }

    public void addInputGate(InputGate gate) {
        this.inputs.add(gate);
    }

    public <T> void addOutput(final Queue<Object> outputList, TypeSerializer<T> serializer) {
        try {
            BufferProvider mockBufferProvider = (BufferProvider)Mockito.mock(BufferProvider.class);
            Mockito.when((Object)mockBufferProvider.requestBufferBlocking()).thenAnswer((Answer)new Answer<Buffer>(){

                public Buffer answer(InvocationOnMock invocationOnMock) throws Throwable {
                    return new Buffer(MemorySegmentFactory.allocateUnpooledSegment((int)StreamMockEnvironment.this.bufferSize), (BufferRecycler)Mockito.mock(BufferRecycler.class));
                }
            });
            ResultPartitionWriter mockWriter = (ResultPartitionWriter)Mockito.mock(ResultPartitionWriter.class);
            Mockito.when((Object)mockWriter.getNumberOfOutputChannels()).thenReturn((Object)1);
            Mockito.when((Object)mockWriter.getBufferProvider()).thenReturn((Object)mockBufferProvider);
            AdaptiveSpanningRecordDeserializer recordDeserializer = new AdaptiveSpanningRecordDeserializer();
            NonReusingDeserializationDelegate delegate = new NonReusingDeserializationDelegate(serializer);
            ((ResultPartitionWriter)Mockito.doAnswer((Answer)new Answer<Void>((RecordDeserializer)recordDeserializer, delegate, outputList){
                final /* synthetic */ RecordDeserializer val$recordDeserializer;
                final /* synthetic */ NonReusingDeserializationDelegate val$delegate;
                final /* synthetic */ Queue val$outputList;
                {
                    this.val$recordDeserializer = recordDeserializer;
                    this.val$delegate = nonReusingDeserializationDelegate;
                    this.val$outputList = queue;
                }

                public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                    Buffer buffer = (Buffer)invocationOnMock.getArguments()[0];
                    this.val$recordDeserializer.setNextBuffer(buffer);
                    while (this.val$recordDeserializer.hasUnfinishedData()) {
                        RecordDeserializer.DeserializationResult result = this.val$recordDeserializer.getNextRecord((IOReadableWritable)this.val$delegate);
                        if (result.isFullRecord()) {
                            this.val$outputList.add(this.val$delegate.getInstance());
                        }
                        if (result != RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER && result != RecordDeserializer.DeserializationResult.PARTIAL_RECORD) continue;
                        break;
                    }
                    return null;
                }
            }).when((Object)mockWriter)).writeBuffer((Buffer)Matchers.any(Buffer.class), Matchers.anyInt());
            ((ResultPartitionWriter)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                    AbstractEvent event = (AbstractEvent)invocationOnMock.getArguments()[0];
                    outputList.add(event);
                    return null;
                }
            }).when((Object)mockWriter)).writeEvent((AbstractEvent)Matchers.any(AbstractEvent.class), Matchers.anyInt());
            ((ResultPartitionWriter)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                    AbstractEvent event = (AbstractEvent)invocationOnMock.getArguments()[0];
                    outputList.add(event);
                    return null;
                }
            }).when((Object)mockWriter)).writeEventToAllChannels((AbstractEvent)Matchers.any(AbstractEvent.class));
            this.outputs.add(mockWriter);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    public MemoryManager getMemoryManager() {
        return this.memManager;
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public InputSplitProvider getInputSplitProvider() {
        return this.inputSplitProvider;
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public ClassLoader getUserClassLoader() {
        return this.getClass().getClassLoader();
    }

    public Map<String, Future<Path>> getDistributedCacheEntries() {
        return Collections.emptyMap();
    }

    public ResultPartitionWriter getWriter(int index) {
        return this.outputs.get(index);
    }

    public ResultPartitionWriter[] getAllWriters() {
        return this.outputs.toArray(new ResultPartitionWriter[this.outputs.size()]);
    }

    public InputGate getInputGate(int index) {
        return this.inputs.get(index);
    }

    public InputGate[] getAllInputGates() {
        InputGate[] gates = new InputGate[this.inputs.size()];
        this.inputs.toArray(gates);
        return gates;
    }

    public JobVertexID getJobVertexId() {
        return new JobVertexID(new byte[16]);
    }

    public ExecutionAttemptID getExecutionId() {
        return new ExecutionAttemptID(0L, 0L);
    }

    public BroadcastVariableManager getBroadcastVariableManager() {
        return this.bcVarManager;
    }

    public AccumulatorRegistry getAccumulatorRegistry() {
        return this.accumulatorRegistry;
    }

    public void acknowledgeCheckpoint(long checkpointId) {
    }

    public void acknowledgeCheckpoint(long checkpointId, StateHandle<?> state) {
    }

    public void failExternally(Throwable cause) {
        throw new UnsupportedOperationException("StreamMockEnvironment does not support external task failure.");
    }

    public TaskManagerRuntimeInfo getTaskManagerInfo() {
        return new TaskManagerRuntimeInfo("localhost", new Configuration(), System.getProperty("java.io.tmpdir"));
    }

    public TaskMetricGroup getMetricGroup() {
        return new UnregisteredTaskMetricsGroup();
    }
}

