/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.util.DataInputDeserializer;
import org.apache.flink.runtime.util.DataOutputSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecordSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class StreamRecordSerializerTest {
    @Test
    public void testDeepDuplication() {
        try {
            TypeSerializer serializer1 = (TypeSerializer)Mockito.mock(TypeSerializer.class);
            TypeSerializer serializer2 = (TypeSerializer)Mockito.mock(TypeSerializer.class);
            Mockito.when((Object)serializer1.duplicate()).thenReturn((Object)serializer2);
            StreamRecordSerializer streamRecSer = new StreamRecordSerializer(serializer1);
            Assert.assertEquals((Object)serializer1, (Object)streamRecSer.getContainedTypeSerializer());
            StreamRecordSerializer copy = streamRecSer.duplicate();
            Assert.assertNotEquals((Object)copy, (Object)streamRecSer);
            Assert.assertNotEquals((Object)copy.getContainedTypeSerializer(), (Object)streamRecSer.getContainedTypeSerializer());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBasicProperties() {
        try {
            StreamRecordSerializer streamRecSer = new StreamRecordSerializer((TypeSerializer)LongSerializer.INSTANCE);
            Assert.assertFalse((boolean)streamRecSer.isImmutableType());
            Assert.assertEquals(Long.class, ((Long)streamRecSer.createInstance().getValue()).getClass());
            Assert.assertEquals((long)LongSerializer.INSTANCE.getLength(), (long)streamRecSer.getLength());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeserializedValuesHaveNoTimestamps() throws Exception {
        StreamRecord original = new StreamRecord((Object)42L);
        StreamRecordSerializer streamRecSer = new StreamRecordSerializer((TypeSerializer)LongSerializer.INSTANCE);
        DataOutputSerializer buffer = new DataOutputSerializer(16);
        streamRecSer.serialize(original, (DataOutputView)buffer);
        DataInputDeserializer input = new DataInputDeserializer(buffer.getByteArray(), 0, buffer.length());
        StreamRecord result = streamRecSer.deserialize((DataInputView)input);
        Assert.assertFalse((boolean)result.hasTimestamp());
        Assert.assertEquals((Object)original, (Object)result);
    }
}

