/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.ShufflePartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ShufflePartitionerTest {
    private ShufflePartitioner<Tuple> shufflePartitioner;
    private StreamRecord<Tuple> streamRecord = new StreamRecord(null);
    private SerializationDelegate<StreamRecord<Tuple>> sd = new SerializationDelegate(null);

    @Before
    public void setPartitioner() {
        this.shufflePartitioner = new ShufflePartitioner();
    }

    @Test
    public void testSelectChannelsLength() {
        this.sd.setInstance(this.streamRecord);
        Assert.assertEquals((long)1L, (long)this.shufflePartitioner.selectChannels(this.sd, 1).length);
        Assert.assertEquals((long)1L, (long)this.shufflePartitioner.selectChannels(this.sd, 2).length);
        Assert.assertEquals((long)1L, (long)this.shufflePartitioner.selectChannels(this.sd, 1024).length);
    }

    @Test
    public void testSelectChannelsInterval() {
        this.sd.setInstance(this.streamRecord);
        Assert.assertEquals((long)0L, (long)this.shufflePartitioner.selectChannels(this.sd, 1)[0]);
        Assert.assertTrue((0 <= this.shufflePartitioner.selectChannels(this.sd, 2)[0] ? 1 : 0) != 0);
        Assert.assertTrue((2 > this.shufflePartitioner.selectChannels(this.sd, 2)[0] ? 1 : 0) != 0);
        Assert.assertTrue((0 <= this.shufflePartitioner.selectChannels(this.sd, 1024)[0] ? 1 : 0) != 0);
        Assert.assertTrue((1024 > this.shufflePartitioner.selectChannels(this.sd, 1024)[0] ? 1 : 0) != 0);
    }
}

