/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.windowing.AllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.windowing.assigners.SlidingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.AccumulatingProcessingTimeWindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.AggregatingProcessingTimeWindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperator;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TimeWindowTranslationTest {
    @Test
    public void testFastTimeWindows() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window1 = source.keyBy(new int[]{0}).timeWindow(Time.of((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS), Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).reduce((ReduceFunction)reducer);
        OneInputTransformation transform1 = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator1 = transform1.getOperator();
        Assert.assertTrue((boolean)(operator1 instanceof AggregatingProcessingTimeWindowOperator));
        SingleOutputStreamOperator window2 = source.keyBy(new int[]{0}).timeWindow(Time.of((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS)).apply((WindowFunction)new WindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, Tuple, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(Tuple tuple, TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
            }
        });
        OneInputTransformation transform2 = (OneInputTransformation)window2.getTransformation();
        OneInputStreamOperator operator2 = transform2.getOperator();
        Assert.assertTrue((boolean)(operator2 instanceof AccumulatingProcessingTimeWindowOperator));
    }

    @Test
    public void testEventTimeWindows() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window1 = source.keyBy(new int[]{0}).timeWindow(Time.of((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS), Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).reduce((ReduceFunction)reducer);
        OneInputTransformation transform1 = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator1 = transform1.getOperator();
        Assert.assertTrue((boolean)(operator1 instanceof WindowOperator));
        WindowOperator winOperator1 = (WindowOperator)operator1;
        Assert.assertTrue((boolean)(winOperator1.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator1.getWindowAssigner() instanceof SlidingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator1.getStateDescriptor() instanceof ReducingStateDescriptor));
        SingleOutputStreamOperator window2 = source.keyBy(new int[]{0}).timeWindow(Time.of((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS)).apply((WindowFunction)new WindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, Tuple, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(Tuple tuple, TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
            }
        });
        OneInputTransformation transform2 = (OneInputTransformation)window2.getTransformation();
        OneInputStreamOperator operator2 = transform2.getOperator();
        Assert.assertTrue((boolean)(operator2 instanceof WindowOperator));
        WindowOperator winOperator2 = (WindowOperator)operator2;
        Assert.assertTrue((boolean)(winOperator2.getTrigger() instanceof EventTimeTrigger));
        Assert.assertTrue((boolean)(winOperator2.getWindowAssigner() instanceof TumblingEventTimeWindows));
        Assert.assertTrue((boolean)(winOperator2.getStateDescriptor() instanceof ListStateDescriptor));
    }

    @Ignore
    @Test
    public void testNonParallelFastTimeWindows() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Tuple2[]{Tuple2.of((Object)"hello", (Object)1), Tuple2.of((Object)"hello", (Object)2)});
        DummyReducer reducer = new DummyReducer();
        SingleOutputStreamOperator window1 = source.timeWindowAll(Time.of((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS), Time.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS)).reduce((ReduceFunction)reducer);
        OneInputTransformation transform1 = (OneInputTransformation)window1.getTransformation();
        OneInputStreamOperator operator1 = transform1.getOperator();
        Assert.assertTrue((boolean)(operator1 instanceof AggregatingProcessingTimeWindowOperator));
        SingleOutputStreamOperator window2 = source.timeWindowAll(Time.of((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS)).apply((AllWindowFunction)new AllWindowFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, TimeWindow>(){
            private static final long serialVersionUID = 1L;

            public void apply(TimeWindow window, Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) throws Exception {
            }
        });
        OneInputTransformation transform2 = (OneInputTransformation)window2.getTransformation();
        OneInputStreamOperator operator2 = transform2.getOperator();
        Assert.assertTrue((boolean)(operator2 instanceof AccumulatingProcessingTimeWindowOperator));
    }

    public static class DummyReducer
    implements ReduceFunction<Tuple2<String, Integer>> {
        private static final long serialVersionUID = 1L;

        public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) throws Exception {
            return value1;
        }
    }
}

