/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class CollectingOutput<T>
implements Output<StreamRecord<T>> {
    private final List<T> elements = new ArrayList<T>();
    private final int timeStampModulus;

    public CollectingOutput() {
        this.timeStampModulus = 0;
    }

    public CollectingOutput(int timeStampModulus) {
        this.timeStampModulus = timeStampModulus;
    }

    public List<T> getElements() {
        return this.elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNElements(int n, long timeout) throws InterruptedException {
        long deadline = System.currentTimeMillis() + timeout;
        List<T> list = this.elements;
        synchronized (list) {
            long now;
            while (this.elements.size() < n && (now = System.currentTimeMillis()) < deadline) {
                this.elements.wait(deadline - now);
            }
        }
    }

    public void emitWatermark(Watermark mark) {
        throw new UnsupportedOperationException("the output should not emit watermarks");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(StreamRecord<T> record) {
        this.elements.add(record.getValue());
        if (this.timeStampModulus != 0 && record.getTimestamp() % (long)this.timeStampModulus != 0L) {
            throw new IllegalArgumentException("Invalid timestamp");
        }
        List<T> list = this.elements;
        synchronized (list) {
            this.elements.notifyAll();
        }
    }

    public void close() {
    }
}

