/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.DiscardingSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.FromElementsFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.functions.source.StatefulSequenceSource;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.util.SplittableIterator;
import org.junit.Assert;
import org.junit.Test;

public class StreamExecutionEnvironmentTest {
    @Test
    public void fromElementsWithBaseTypeTest1() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.fromElements(ParentClass.class, (Object[])new ParentClass[]{new SubClass(1, "Java"), new ParentClass(1, "hello")});
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromElementsWithBaseTypeTest2() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.fromElements(new Object[]{SubClass.class, new SubClass(1, "Java"), new ParentClass(1, "hello")});
    }

    @Test
    public void testFromCollectionParallelism() {
        try {
            BasicTypeInfo typeInfo = BasicTypeInfo.INT_TYPE_INFO;
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            DataStreamSource dataStream1 = env.fromCollection(new DummySplittableIterator(), (TypeInformation)typeInfo);
            try {
                dataStream1.setParallelism(4);
                Assert.fail((String)"should throw an exception");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            dataStream1.addSink((SinkFunction)new DiscardingSink());
            DataStreamSource dataStream2 = env.fromParallelCollection(new DummySplittableIterator(), (TypeInformation)typeInfo).setParallelism(4);
            dataStream2.addSink((SinkFunction)new DiscardingSink());
            env.getExecutionPlan();
            Assert.assertEquals((String)"Parallelism of collection source must be 1.", (long)1L, (long)env.getStreamGraph().getStreamNode(Integer.valueOf(dataStream1.getId())).getParallelism());
            Assert.assertEquals((String)"Parallelism of parallel collection source must be 4.", (long)4L, (long)env.getStreamGraph().getStreamNode(Integer.valueOf(dataStream2.getId())).getParallelism());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSources() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        SourceFunction<Integer> srcFun = new SourceFunction<Integer>(){
            private static final long serialVersionUID = 1L;

            public void run(SourceFunction.SourceContext<Integer> ctx) throws Exception {
            }

            public void cancel() {
            }
        };
        DataStreamSource src1 = env.addSource((SourceFunction)srcFun);
        src1.addSink((SinkFunction)new DiscardingSink());
        Assert.assertEquals((Object)srcFun, StreamExecutionEnvironmentTest.getFunctionFromDataSource(src1));
        List<Long> list = Arrays.asList(0L, 1L, 2L);
        DataStreamSource src2 = env.generateSequence(0L, 2L);
        Assert.assertTrue((boolean)(StreamExecutionEnvironmentTest.getFunctionFromDataSource(src2) instanceof StatefulSequenceSource));
        DataStreamSource src3 = env.fromElements((Object[])new Long[]{0L, 1L, 2L});
        Assert.assertTrue((boolean)(StreamExecutionEnvironmentTest.getFunctionFromDataSource(src3) instanceof FromElementsFunction));
        DataStreamSource src4 = env.fromCollection(list);
        Assert.assertTrue((boolean)(StreamExecutionEnvironmentTest.getFunctionFromDataSource(src4) instanceof FromElementsFunction));
    }

    private static StreamOperator<?> getOperatorFromDataStream(DataStream<?> dataStream) {
        StreamExecutionEnvironment env = dataStream.getExecutionEnvironment();
        StreamGraph streamGraph = env.getStreamGraph();
        return streamGraph.getStreamNode(Integer.valueOf(dataStream.getId())).getOperator();
    }

    private static <T> SourceFunction<T> getFunctionFromDataSource(DataStreamSource<T> dataStreamSource) {
        dataStreamSource.addSink((SinkFunction)new DiscardingSink());
        AbstractUdfStreamOperator operator = (AbstractUdfStreamOperator)StreamExecutionEnvironmentTest.getOperatorFromDataStream(dataStreamSource);
        return (SourceFunction)operator.getUserFunction();
    }

    public static class SubClass
    extends ParentClass {
        public SubClass(int num, String string) {
            super(num, string);
        }
    }

    public static class ParentClass {
        int num;
        String string;

        public ParentClass(int num, String string) {
            this.num = num;
            this.string = string;
        }
    }

    public static class DummySplittableIterator<T>
    extends SplittableIterator<T> {
        private static final long serialVersionUID = 1312752876092210499L;

        public Iterator<T>[] split(int numPartitions) {
            return new Iterator[0];
        }

        public int getMaximumNumberOfSplits() {
            return 0;
        }

        public boolean hasNext() {
            return false;
        }

        public T next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

