/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.KvStateSnapshot;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.streaming.runtime.tasks.StreamTaskState;

@Internal
public class StreamTaskStateList
implements StateHandle<StreamTaskState[]> {
    private static final long serialVersionUID = 1L;
    private final StreamTaskState[] states;

    public StreamTaskStateList(StreamTaskState[] states) throws Exception {
        this.states = states;
    }

    public boolean isEmpty() {
        for (StreamTaskState state : this.states) {
            if (state == null) continue;
            return false;
        }
        return true;
    }

    public StreamTaskState[] getState(ClassLoader userCodeClassLoader) {
        return this.states;
    }

    public void discardState() throws Exception {
        for (StreamTaskState state : this.states) {
            if (state == null) continue;
            state.discardState();
        }
    }

    public long getStateSize() throws Exception {
        long sumStateSize = 0L;
        if (this.states != null) {
            for (StreamTaskState state : this.states) {
                if (state == null) continue;
                StateHandle<?> operatorState = state.getOperatorState();
                StateHandle<Serializable> functionState = state.getFunctionState();
                HashMap<String, KvStateSnapshot<?, ?, ?, ?, ?>> kvStates = state.getKvStates();
                if (operatorState != null) {
                    sumStateSize += operatorState.getStateSize();
                }
                if (functionState != null) {
                    sumStateSize += functionState.getStateSize();
                }
                if (kvStates == null) continue;
                for (KvStateSnapshot<?, ?, ?, ?, ?> kvState : kvStates.values()) {
                    if (kvState == null) continue;
                    sumStateSize += kvState.getStateSize();
                }
            }
        }
        return sumStateSize;
    }
}

