/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.triggers;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.Window;

@PublicEvolving
public class ContinuousProcessingTimeTrigger<W extends Window>
extends Trigger<Object, W> {
    private static final long serialVersionUID = 1L;
    private final long interval;
    private final ValueStateDescriptor<Long> stateDesc = new ValueStateDescriptor("fire-timestamp", (TypeSerializer)LongSerializer.INSTANCE, (Object)0L);

    private ContinuousProcessingTimeTrigger(long interval) {
        this.interval = interval;
    }

    @Override
    public TriggerResult onElement(Object element, long timestamp, W window, Trigger.TriggerContext ctx) throws Exception {
        long currentTime = System.currentTimeMillis();
        ValueState fireState = (ValueState)ctx.getPartitionedState(this.stateDesc);
        long nextFireTimestamp = (Long)fireState.value();
        if (nextFireTimestamp == 0L) {
            long start = currentTime - currentTime % this.interval;
            fireState.update((Object)(start + this.interval));
            ctx.registerProcessingTimeTimer(start + this.interval);
            return TriggerResult.CONTINUE;
        }
        if (currentTime > nextFireTimestamp) {
            long start = currentTime - currentTime % this.interval;
            fireState.update((Object)(start + this.interval));
            ctx.registerProcessingTimeTimer(start + this.interval);
            return TriggerResult.FIRE;
        }
        return TriggerResult.CONTINUE;
    }

    @Override
    public TriggerResult onEventTime(long time, W window, Trigger.TriggerContext ctx) throws Exception {
        return TriggerResult.CONTINUE;
    }

    @Override
    public TriggerResult onProcessingTime(long time, W window, Trigger.TriggerContext ctx) throws Exception {
        ValueState fireState = (ValueState)ctx.getPartitionedState(this.stateDesc);
        long nextFireTimestamp = (Long)fireState.value();
        long currentTime = System.currentTimeMillis();
        if (currentTime > nextFireTimestamp) {
            long start = currentTime - currentTime % this.interval;
            fireState.update((Object)(start + this.interval));
            return TriggerResult.FIRE;
        }
        return TriggerResult.CONTINUE;
    }

    @Override
    public void clear(W window, Trigger.TriggerContext ctx) throws Exception {
    }

    @VisibleForTesting
    public long getInterval() {
        return this.interval;
    }

    public String toString() {
        return "ContinuousProcessingTimeTrigger(" + this.interval + ")";
    }

    public static <W extends Window> ContinuousProcessingTimeTrigger<W> of(Time interval) {
        return new ContinuousProcessingTimeTrigger<W>(interval.toMilliseconds());
    }
}

