/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.api.transformations.SourceTransformation;

@Public
public class DataStreamSource<T>
extends SingleOutputStreamOperator<T> {
    boolean isParallel;

    public DataStreamSource(StreamExecutionEnvironment environment, TypeInformation<T> outTypeInfo, StreamSource<T, ?> operator, boolean isParallel, String sourceName) {
        super(environment, new SourceTransformation<T>(sourceName, operator, outTypeInfo, environment.getParallelism()));
        this.isParallel = isParallel;
        if (!isParallel) {
            this.setParallelism(1);
        }
    }

    @Override
    public DataStreamSource<T> setParallelism(int parallelism) {
        if (parallelism > 1 && !this.isParallel) {
            throw new IllegalArgumentException("Source: " + this.transformation.getId() + " is not a parallel source");
        }
        return (DataStreamSource)super.setParallelism(parallelism);
    }
}

