/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.SupportsConcurrentExecutionAttempts;
import org.apache.flink.api.common.functions.util.PrintSinkOutputWriter;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;

@PublicEvolving
public class PrintSink<IN>
implements Sink<IN>,
SupportsConcurrentExecutionAttempts {
    private static final long serialVersionUID = 1L;
    private final String sinkIdentifier;
    private final boolean stdErr;

    public PrintSink() {
        this("");
    }

    public PrintSink(boolean stdErr) {
        this("", stdErr);
    }

    public PrintSink(String sinkIdentifier) {
        this(sinkIdentifier, false);
    }

    public PrintSink(String sinkIdentifier, boolean stdErr) {
        this.sinkIdentifier = sinkIdentifier;
        this.stdErr = stdErr;
    }

    public SinkWriter<IN> createWriter(Sink.InitContext context) throws IOException {
        PrintSinkOutputWriter writer = new PrintSinkOutputWriter(this.sinkIdentifier, this.stdErr);
        writer.open(context.getSubtaskId(), context.getNumberOfParallelSubtasks());
        return writer;
    }

    public String toString() {
        return "Print to " + (this.stdErr ? "System.err" : "System.out");
    }
}

