/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.watermarkstatus;

import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.junit.Assert;
import org.junit.Test;

public class WatermarkStatusTest {
    @Test(expected=IllegalArgumentException.class)
    public void testIllegalCreationThrowsException() {
        new WatermarkStatus(32);
    }

    @Test
    public void testEquals() {
        WatermarkStatus idleStatus = new WatermarkStatus(-1);
        WatermarkStatus activeStatus = new WatermarkStatus(0);
        Assert.assertEquals((Object)WatermarkStatus.IDLE, (Object)idleStatus);
        Assert.assertTrue((boolean)idleStatus.isIdle());
        Assert.assertFalse((boolean)idleStatus.isActive());
        Assert.assertEquals((Object)WatermarkStatus.ACTIVE, (Object)activeStatus);
        Assert.assertTrue((boolean)activeStatus.isActive());
        Assert.assertFalse((boolean)activeStatus.isIdle());
    }

    @Test
    public void testTypeCasting() {
        WatermarkStatus status = WatermarkStatus.ACTIVE;
        Assert.assertTrue((boolean)status.isWatermarkStatus());
        Assert.assertFalse((boolean)status.isRecord());
        Assert.assertFalse((boolean)status.isWatermark());
        Assert.assertFalse((boolean)status.isLatencyMarker());
        try {
            status.asWatermark();
            Assert.fail((String)"should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            status.asRecord();
            Assert.fail((String)"should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            status.asLatencyMarker();
            Assert.fail((String)"should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

