/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.KeyGroupStreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KeyGroupStreamPartitionerTest
extends TestLogger {
    private KeyGroupStreamPartitioner<Tuple2<String, Integer>, String> keyGroupPartitioner;
    private StreamRecord<Tuple2<String, Integer>> streamRecord1 = new StreamRecord((Object)new Tuple2((Object)"test", (Object)0));
    private StreamRecord<Tuple2<String, Integer>> streamRecord2 = new StreamRecord((Object)new Tuple2((Object)"test", (Object)42));
    private SerializationDelegate<StreamRecord<Tuple2<String, Integer>>> serializationDelegate1 = new SerializationDelegate(null);
    private SerializationDelegate<StreamRecord<Tuple2<String, Integer>>> serializationDelegate2 = new SerializationDelegate(null);

    @Before
    public void setPartitioner() {
        this.keyGroupPartitioner = new KeyGroupStreamPartitioner((KeySelector)new KeySelector<Tuple2<String, Integer>, String>(){
            private static final long serialVersionUID = 1L;

            public String getKey(Tuple2<String, Integer> value) throws Exception {
                return (String)value.getField(0);
            }
        }, 1024);
    }

    @Test
    public void testSelectChannelsGrouping() {
        this.serializationDelegate1.setInstance(this.streamRecord1);
        this.serializationDelegate2.setInstance(this.streamRecord2);
        Assert.assertEquals((long)this.selectChannels(this.serializationDelegate1, 1), (long)this.selectChannels(this.serializationDelegate2, 1));
        Assert.assertEquals((long)this.selectChannels(this.serializationDelegate1, 2), (long)this.selectChannels(this.serializationDelegate2, 2));
        Assert.assertEquals((long)this.selectChannels(this.serializationDelegate1, 1024), (long)this.selectChannels(this.serializationDelegate2, 1024));
    }

    private int selectChannels(SerializationDelegate<StreamRecord<Tuple2<String, Integer>>> serializationDelegate, int numberOfChannels) {
        this.keyGroupPartitioner.setup(numberOfChannels);
        return this.keyGroupPartitioner.selectChannel(serializationDelegate);
    }
}

