/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.transformations.StreamExchangeMode;
import org.apache.flink.streaming.runtime.partitioner.ForwardForConsecutiveHashPartitioner;
import org.apache.flink.streaming.runtime.partitioner.ForwardPartitioner;
import org.apache.flink.streaming.runtime.partitioner.KeyGroupStreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitionerTestUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class ForwardForConsecutiveHashPartitionerTest
extends TestLogger {
    @Test
    public void testConvertToForwardPartitioner() {
        this.testConvertToForwardPartitioner(StreamExchangeMode.BATCH);
        this.testConvertToForwardPartitioner(StreamExchangeMode.PIPELINED);
        this.testConvertToForwardPartitioner(StreamExchangeMode.UNDEFINED);
    }

    private void testConvertToForwardPartitioner(StreamExchangeMode streamExchangeMode) {
        JobGraph jobGraph = StreamPartitionerTestUtils.createJobGraph("group1", "group1", (StreamPartitioner<Long>)new ForwardForConsecutiveHashPartitioner((StreamPartitioner)new KeyGroupStreamPartitioner((KeySelector & Serializable)record -> 0L, 100)));
        List jobVertices = jobGraph.getVerticesSortedTopologicallyFromSources();
        MatcherAssert.assertThat((Object)jobVertices.size(), (Matcher)CoreMatchers.is((Object)1));
        JobVertex vertex = (JobVertex)jobGraph.getVerticesSortedTopologicallyFromSources().get(0);
        StreamConfig sourceConfig = new StreamConfig(vertex.getConfiguration());
        StreamEdge edge = (StreamEdge)sourceConfig.getChainedOutputs(((Object)((Object)this)).getClass().getClassLoader()).get(0);
        MatcherAssert.assertThat((Object)edge.getPartitioner(), (Matcher)CoreMatchers.instanceOf(ForwardPartitioner.class));
    }

    @Test
    public void testConvertToHashPartitioner() {
        this.testConvertToHashPartitioner(StreamExchangeMode.BATCH);
        this.testConvertToHashPartitioner(StreamExchangeMode.PIPELINED);
        this.testConvertToHashPartitioner(StreamExchangeMode.UNDEFINED);
    }

    private void testConvertToHashPartitioner(StreamExchangeMode streamExchangeMode) {
        JobGraph jobGraph = StreamPartitionerTestUtils.createJobGraph("group1", "group2", (StreamPartitioner<Long>)new ForwardForConsecutiveHashPartitioner((StreamPartitioner)new KeyGroupStreamPartitioner((KeySelector & Serializable)record -> 0L, 100)));
        List jobVertices = jobGraph.getVerticesSortedTopologicallyFromSources();
        MatcherAssert.assertThat((Object)jobVertices.size(), (Matcher)CoreMatchers.is((Object)2));
        JobVertex sourceVertex = (JobVertex)jobGraph.getVerticesSortedTopologicallyFromSources().get(0);
        StreamConfig sourceConfig = new StreamConfig(sourceVertex.getConfiguration());
        StreamEdge edge = (StreamEdge)sourceConfig.getNonChainedOutputs(((Object)((Object)this)).getClass().getClassLoader()).get(0);
        MatcherAssert.assertThat((Object)edge.getPartitioner(), (Matcher)CoreMatchers.instanceOf(KeyGroupStreamPartitioner.class));
    }
}

