/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink.committables;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalLong;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.streaming.api.connector.sink2.CommittableWithLineage;
import org.apache.flink.streaming.runtime.operators.sink.committables.CommitRequestImpl;
import org.apache.flink.streaming.runtime.operators.sink.committables.SubtaskCommittableManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SubtaskCommittableManagerTest {
    SubtaskCommittableManagerTest() {
    }

    @Test
    void testDrainCommittables() {
        SubtaskCommittableManager subtaskCommittableManager = new SubtaskCommittableManager(3, 1, Long.valueOf(1L));
        CommittableWithLineage first = new CommittableWithLineage((Object)1, Long.valueOf(1L), 1);
        CommittableWithLineage second = new CommittableWithLineage((Object)2, Long.valueOf(1L), 1);
        CommittableWithLineage third = new CommittableWithLineage((Object)3, Long.valueOf(1L), 1);
        Assertions.assertThat((Stream)subtaskCommittableManager.getPendingRequests()).hasSize(0);
        subtaskCommittableManager.add(first);
        subtaskCommittableManager.add(second);
        subtaskCommittableManager.add(third);
        Assertions.assertThat((Stream)subtaskCommittableManager.getPendingRequests()).hasSize(3);
        Assertions.assertThat((int)subtaskCommittableManager.getNumCommittables()).isEqualTo(3);
        Assertions.assertThat((int)subtaskCommittableManager.getNumDrained()).isEqualTo(0);
        Assertions.assertThat((boolean)subtaskCommittableManager.isFinished()).isFalse();
        Iterator requests = subtaskCommittableManager.getRequests().iterator();
        IntStream.range(0, 2).forEach(i -> ((CommitRequestImpl)requests.next()).setCommittedIfNoError());
        Assertions.assertThat((Stream)subtaskCommittableManager.getPendingRequests()).hasSize(1);
        Assertions.assertThat((int)subtaskCommittableManager.getNumCommittables()).isEqualTo(3);
        Assertions.assertThat((int)subtaskCommittableManager.getNumDrained()).isEqualTo(0);
        List committables = subtaskCommittableManager.drainCommitted();
        Assertions.assertThat((List)committables).hasSize(2);
        Assertions.assertThat(committables.get(0)).satisfies(c -> {
            Assertions.assertThat((int)c.getSubtaskId()).isEqualTo(1);
            Assertions.assertThat((Integer)((Integer)c.getCommittable())).isEqualTo(1);
            Assertions.assertThat((OptionalLong)c.getCheckpointId()).hasValue(1L);
        });
        Assertions.assertThat(committables.get(1)).satisfies(c -> {
            Assertions.assertThat((int)c.getSubtaskId()).isEqualTo(1);
            Assertions.assertThat((Integer)((Integer)c.getCommittable())).isEqualTo(2);
            Assertions.assertThat((OptionalLong)c.getCheckpointId()).hasValue(1L);
        });
        Assertions.assertThat((int)subtaskCommittableManager.getNumFailed()).isEqualTo(0);
        Assertions.assertThat((List)subtaskCommittableManager.drainCommitted()).hasSize(0);
        ((CommitRequestImpl)requests.next()).signalFailedWithKnownReason((Throwable)new RuntimeException("Unused exception"));
        Assertions.assertThat((int)subtaskCommittableManager.getNumFailed()).isEqualTo(0);
        Assertions.assertThat((Stream)subtaskCommittableManager.getPendingRequests()).hasSize(0);
        Assertions.assertThat((int)subtaskCommittableManager.getNumCommittables()).isEqualTo(3);
        Assertions.assertThat((boolean)subtaskCommittableManager.isFinished()).isFalse();
        Assertions.assertThat((List)subtaskCommittableManager.drainCommitted()).hasSize(0);
        Assertions.assertThat((int)subtaskCommittableManager.getNumFailed()).isEqualTo(1);
        Assertions.assertThat((boolean)subtaskCommittableManager.isFinished()).isTrue();
    }

    @Test
    void testMerge() {
        SubtaskCommittableManager subtaskCommittableManager = new SubtaskCommittableManager(Collections.singletonList(new CommitRequestImpl((Object)1)), 5, 1, 2, 1, Long.valueOf(2L));
        subtaskCommittableManager.merge(new SubtaskCommittableManager(Arrays.asList(new CommitRequestImpl((Object)2), new CommitRequestImpl((Object)3)), 10, 2, 3, 1, Long.valueOf(2L)));
        Assertions.assertThat((int)subtaskCommittableManager.getNumCommittables()).isEqualTo(11);
        Assertions.assertThat((int)subtaskCommittableManager.getNumDrained()).isEqualTo(3);
        Assertions.assertThat((boolean)subtaskCommittableManager.isFinished()).isFalse();
        Assertions.assertThat((int)subtaskCommittableManager.getNumFailed()).isEqualTo(5);
        Assertions.assertThat((Stream)subtaskCommittableManager.getPendingRequests()).hasSize(3);
    }
}

