/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink.committables;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.api.connector.sink2.Committer;
import org.apache.flink.streaming.api.connector.sink2.CommittableSummary;
import org.apache.flink.streaming.api.connector.sink2.CommittableWithLineage;
import org.apache.flink.streaming.runtime.operators.sink.committables.CheckpointCommittableManagerImpl;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

class CheckpointCommittableManagerImplTest {
    CheckpointCommittableManagerImplTest() {
    }

    @Test
    void testAddSummary() {
        CheckpointCommittableManagerImpl checkpointCommittables = new CheckpointCommittableManagerImpl(2, 1, Long.valueOf(1L));
        Assertions.assertThat((Collection)checkpointCommittables.getSubtaskCommittableManagers()).isEmpty();
        CommittableSummary first = new CommittableSummary(1, 1, Long.valueOf(1L), 1, 0, 0);
        checkpointCommittables.upsertSummary(first);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)checkpointCommittables.getSubtaskCommittableManagers()).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{s -> {
            Assertions.assertThat((int)s.getSubtaskId()).isEqualTo(2);
            Assertions.assertThat((Long)s.getCheckpointId()).isEqualTo(1L);
            Assertions.assertThat((int)s.getNumPending()).isEqualTo(1);
            Assertions.assertThat((int)s.getNumFailed()).isEqualTo(0);
        }});
        CommittableSummary third = new CommittableSummary(2, 1, Long.valueOf(2L), 2, 1, 1);
        checkpointCommittables.upsertSummary(third);
        Assertions.assertThat((Collection)checkpointCommittables.getSubtaskCommittableManagers()).hasSize(2);
    }

    @Test
    void testCommit() throws IOException, InterruptedException {
        CheckpointCommittableManagerImpl checkpointCommittables = new CheckpointCommittableManagerImpl(1, 1, Long.valueOf(1L));
        checkpointCommittables.upsertSummary(new CommittableSummary(1, 1, Long.valueOf(1L), 1, 0, 0));
        checkpointCommittables.upsertSummary(new CommittableSummary(2, 1, Long.valueOf(1L), 2, 0, 0));
        checkpointCommittables.addCommittable(new CommittableWithLineage((Object)3, Long.valueOf(1L), 1));
        checkpointCommittables.addCommittable(new CommittableWithLineage((Object)4, Long.valueOf(1L), 2));
        NoOpCommitter committer = new NoOpCommitter();
        Collection commitRequests = checkpointCommittables.commit(true, (Committer)committer);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)commitRequests).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{c -> Assertions.assertThat((Integer)((Integer)c.getCommittable())).isEqualTo(3)});
        commitRequests = checkpointCommittables.commit(false, (Committer)committer);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)commitRequests).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{c -> Assertions.assertThat((Integer)((Integer)c.getCommittable())).isEqualTo(4)});
    }

    @Test
    void testUpdateCommittableSummary() {
        CheckpointCommittableManagerImpl checkpointCommittables = new CheckpointCommittableManagerImpl(1, 1, Long.valueOf(1L));
        checkpointCommittables.upsertSummary(new CommittableSummary(1, 1, Long.valueOf(1L), 1, 0, 0));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> checkpointCommittables.upsertSummary(new CommittableSummary(1, 1, Long.valueOf(1L), 2, 0, 0))).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("FLINK-25920");
    }

    private static class NoOpCommitter
    implements Committer<Integer> {
        private NoOpCommitter() {
        }

        public void commit(Collection<Committer.CommitRequest<Integer>> committables) throws IOException, InterruptedException {
        }

        public void close() throws Exception {
        }
    }
}

