/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetricsBuilder;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;

public class ValidatingCheckpointHandler
extends AbstractInvokable {
    private CheckpointFailureReason failureReason;
    private long lastCanceledCheckpointId = -1L;
    private long abortedCheckpointCounter = 0L;
    final List<Long> abortedCheckpoints = new ArrayList<Long>();
    long nextExpectedCheckpointId;
    long triggeredCheckpointCounter = 0L;
    CompletableFuture<Long> lastAlignmentDurationNanos;
    CompletableFuture<Long> lastBytesProcessedDuringAlignment;
    final List<Long> triggeredCheckpoints = new ArrayList<Long>();
    private final List<CheckpointOptions> triggeredCheckpointOptions = new ArrayList<CheckpointOptions>();

    ValidatingCheckpointHandler() {
        this(-1L);
    }

    ValidatingCheckpointHandler(long nextExpectedCheckpointId) {
        super((Environment)new DummyEnvironment("test", 1, 0));
        this.nextExpectedCheckpointId = nextExpectedCheckpointId;
    }

    void setNextExpectedCheckpointId(long nextExpectedCheckpointId) {
        this.nextExpectedCheckpointId = nextExpectedCheckpointId;
    }

    CheckpointFailureReason getCheckpointFailureReason() {
        return this.failureReason;
    }

    long getLastCanceledCheckpointId() {
        return this.lastCanceledCheckpointId;
    }

    long getTriggeredCheckpointCounter() {
        return this.triggeredCheckpointCounter;
    }

    long getAbortedCheckpointCounter() {
        return this.abortedCheckpointCounter;
    }

    long getNextExpectedCheckpointId() {
        return this.nextExpectedCheckpointId;
    }

    CompletableFuture<Long> getLastAlignmentDurationNanos() {
        return this.lastAlignmentDurationNanos;
    }

    CompletableFuture<Long> getLastBytesProcessedDuringAlignment() {
        return this.lastBytesProcessedDuringAlignment;
    }

    List<CheckpointOptions> getTriggeredCheckpointOptions() {
        return this.triggeredCheckpointOptions;
    }

    public void invoke() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> triggerCheckpointAsync(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions) {
        throw new UnsupportedOperationException("should never be called");
    }

    public void triggerCheckpointOnBarrier(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointMetricsBuilder checkpointMetrics) {
        if (this.nextExpectedCheckpointId != -1L) {
            Assert.assertEquals((long)this.nextExpectedCheckpointId, (long)checkpointMetaData.getCheckpointId());
        }
        Assert.assertTrue((checkpointMetaData.getTimestamp() > 0L ? 1 : 0) != 0);
        this.nextExpectedCheckpointId = checkpointMetaData.getCheckpointId() + 1L;
        ++this.triggeredCheckpointCounter;
        this.lastAlignmentDurationNanos = checkpointMetrics.getAlignmentDurationNanos();
        this.lastBytesProcessedDuringAlignment = checkpointMetrics.getBytesProcessedDuringAlignment();
        if (!checkpointOptions.isUnalignedCheckpoint()) {
            Preconditions.checkCompletedNormally(this.lastAlignmentDurationNanos);
            Preconditions.checkCompletedNormally(this.lastBytesProcessedDuringAlignment);
        }
        this.triggeredCheckpoints.add(checkpointMetaData.getCheckpointId());
        this.triggeredCheckpointOptions.add(checkpointOptions);
    }

    public void abortCheckpointOnBarrier(long checkpointId, CheckpointException cause) {
        this.lastCanceledCheckpointId = checkpointId;
        this.failureReason = cause.getCheckpointFailureReason();
        ++this.abortedCheckpointCounter;
        this.abortedCheckpoints.add(checkpointId);
    }

    public Future<Void> notifyCheckpointCompleteAsync(long checkpointId) {
        throw new UnsupportedOperationException("should never be called");
    }
}

