/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.io.SimpleVersionedSerializerTypeSerializerProxy;
import org.apache.flink.streaming.api.datastream.CustomSinkOperatorUidHashes;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.CommitterOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.SinkWriterOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.TestSink;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SinkTransformationTranslatorTest
extends TestLogger {
    @Parameterized.Parameter
    public RuntimeExecutionMode runtimeExecutionMode;
    static final String NAME = "FileSink";
    static final String SLOT_SHARE_GROUP = "FileGroup";
    static final String UID = "FileUid";
    static final int PARALLELISM = 2;

    @Parameterized.Parameters(name="Execution Mode: {0}")
    public static Collection<Object> data() {
        return Arrays.asList(RuntimeExecutionMode.STREAMING, RuntimeExecutionMode.BATCH);
    }

    @Test
    public void generateWriterTopology() {
        StreamGraph streamGraph = this.buildGraph(TestSink.newBuilder().build(), this.runtimeExecutionMode);
        StreamNode sourceNode = this.findNodeName(streamGraph, node -> node.contains("Source"));
        StreamNode writerNode = this.findWriter(streamGraph);
        MatcherAssert.assertThat((Object)streamGraph.getStreamNodes().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.validateTopology(sourceNode, IntSerializer.class, writerNode, SinkWriterOperatorFactory.class, 2, -1);
    }

    @Test
    public void generateWriterCommitterTopology() {
        StreamGraph streamGraph = this.buildGraph(TestSink.newBuilder().setDefaultCommitter().build(), this.runtimeExecutionMode);
        StreamNode sourceNode = this.findNodeName(streamGraph, node -> node.contains("Source"));
        StreamNode writerNode = this.findWriter(streamGraph);
        this.validateTopology(sourceNode, IntSerializer.class, writerNode, SinkWriterOperatorFactory.class, 2, -1);
        StreamNode committerNode = this.findNodeName(streamGraph, name -> name.contains("Committer"));
        MatcherAssert.assertThat((Object)streamGraph.getStreamNodes().size(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.validateTopology(writerNode, SimpleVersionedSerializerTypeSerializerProxy.class, committerNode, CommitterOperatorFactory.class, 2, -1);
    }

    @Test
    public void generateWriterCommitterGlobalCommitterTopology() {
        StreamGraph streamGraph = this.buildGraph(TestSink.newBuilder().setDefaultCommitter().setDefaultGlobalCommitter().build(), this.runtimeExecutionMode);
        StreamNode sourceNode = this.findNodeName(streamGraph, node -> node.contains("Source"));
        StreamNode writerNode = this.findWriter(streamGraph);
        StreamNode committerNode = this.findCommitter(streamGraph);
        this.validateTopology(sourceNode, IntSerializer.class, writerNode, SinkWriterOperatorFactory.class, 2, -1);
        if (this.runtimeExecutionMode == RuntimeExecutionMode.STREAMING) {
            MatcherAssert.assertThat((Object)streamGraph.getStreamNodes().size(), (Matcher)CoreMatchers.equalTo((Object)4));
        } else {
            MatcherAssert.assertThat((Object)streamGraph.getStreamNodes().size(), (Matcher)CoreMatchers.equalTo((Object)4));
            this.validateTopology(writerNode, SimpleVersionedSerializerTypeSerializerProxy.class, committerNode, CommitterOperatorFactory.class, 2, -1);
        }
        StreamNode lastNode = committerNode;
        StreamNode globalCommitterNode = this.findGlobalCommitter(streamGraph);
        this.validateTopology(lastNode, SimpleVersionedSerializerTypeSerializerProxy.class, globalCommitterNode, SimpleOperatorFactory.class, 1, 1);
    }

    @Test
    public void generateWriterGlobalCommitterTopology() {
        StreamGraph streamGraph = this.buildGraph(TestSink.newBuilder().setCommittableSerializer(TestSink.StringCommittableSerializer.INSTANCE).setGlobalCommittableSerializer(TestSink.StringCommittableSerializer.INSTANCE).setDefaultGlobalCommitter().build(), this.runtimeExecutionMode);
        StreamNode sourceNode = this.findNodeName(streamGraph, node -> node.contains("Source"));
        StreamNode writerNode = this.findWriter(streamGraph);
        this.validateTopology(sourceNode, IntSerializer.class, writerNode, SinkWriterOperatorFactory.class, 2, -1);
        StreamNode committerNode = this.findCommitter(streamGraph);
        StreamNode globalCommitterNode = this.findGlobalCommitter(streamGraph);
        this.validateTopology(writerNode, SimpleVersionedSerializerTypeSerializerProxy.class, committerNode, CommitterOperatorFactory.class, 2, -1);
        this.validateTopology(committerNode, SimpleVersionedSerializerTypeSerializerProxy.class, globalCommitterNode, SimpleOperatorFactory.class, 1, 1);
    }

    private StreamNode findWriter(StreamGraph streamGraph) {
        return this.findNodeName(streamGraph, name -> name.contains("Writer") && !name.contains("Committer"));
    }

    private StreamNode findCommitter(StreamGraph streamGraph) {
        return this.findNodeName(streamGraph, name -> name.contains("Committer"));
    }

    private StreamNode findGlobalCommitter(StreamGraph streamGraph) {
        return this.findNodeName(streamGraph, name -> name.contains("Global Committer"));
    }

    @Test(expected=IllegalStateException.class)
    public void throwExceptionWithoutSettingUid() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        Configuration config = new Configuration();
        config.set(ExecutionOptions.RUNTIME_MODE, (Object)this.runtimeExecutionMode);
        env.configure((ReadableConfig)config, ((Object)((Object)this)).getClass().getClassLoader());
        env.getConfig().disableAutoGeneratedUIDs();
        env.fromElements((Object[])new Integer[]{1, 2}).sinkTo(TestSink.newBuilder().build());
        env.getStreamGraph();
    }

    @Test
    public void disableOperatorChain() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource src = env.fromElements((Object[])new Integer[]{1, 2});
        DataStreamSink dataStreamSink = src.sinkTo(TestSink.newBuilder().setDefaultCommitter().setDefaultGlobalCommitter().build()).name(NAME);
        dataStreamSink.disableChaining();
        StreamGraph streamGraph = env.getStreamGraph();
        StreamNode writer = this.findWriter(streamGraph);
        StreamNode globalCommitter = this.findCommitter(streamGraph);
        MatcherAssert.assertThat((Object)writer.getOperatorFactory().getChainingStrategy(), (Matcher)CoreMatchers.is((Object)ChainingStrategy.NEVER));
        MatcherAssert.assertThat((Object)globalCommitter.getOperatorFactory().getChainingStrategy(), (Matcher)CoreMatchers.is((Object)ChainingStrategy.NEVER));
    }

    @Test
    public void testSettingOperatorUidHash() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource src = env.fromElements((Object[])new Integer[]{1, 2});
        String writerHash = "f6b178ce445dc3ffaa06bad27a51fead";
        String committerHash = "68ac8ae79eae4e3135a54f9689c4aa10";
        String globalCommitterHash = "77e6aa6eeb1643b3765e1e4a7a672f37";
        CustomSinkOperatorUidHashes operatorsUidHashes = CustomSinkOperatorUidHashes.builder().setWriterUidHash("f6b178ce445dc3ffaa06bad27a51fead").setCommitterUidHash("68ac8ae79eae4e3135a54f9689c4aa10").setGlobalCommitterUidHash("77e6aa6eeb1643b3765e1e4a7a672f37").build();
        src.sinkTo(TestSink.newBuilder().setDefaultCommitter().setDefaultGlobalCommitter().build(), operatorsUidHashes).name(NAME);
        StreamGraph streamGraph = env.getStreamGraph();
        Assert.assertEquals((Object)this.findWriter(streamGraph).getUserHash(), (Object)"f6b178ce445dc3ffaa06bad27a51fead");
        Assert.assertEquals((Object)this.findCommitter(streamGraph).getUserHash(), (Object)"68ac8ae79eae4e3135a54f9689c4aa10");
        Assert.assertEquals((Object)this.findGlobalCommitter(streamGraph).getUserHash(), (Object)"77e6aa6eeb1643b3765e1e4a7a672f37");
    }

    @Test
    public void testSettingOperatorUids() {
        String sinkUid = "f6b178ce445dc3ffaa06bad27a51fead";
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource src = env.fromElements((Object[])new Integer[]{1, 2});
        src.sinkTo(TestSink.newBuilder().setDefaultCommitter().setDefaultGlobalCommitter().build()).name(NAME).uid("f6b178ce445dc3ffaa06bad27a51fead");
        StreamGraph streamGraph = env.getStreamGraph();
        Assert.assertEquals((Object)this.findWriter(streamGraph).getTransformationUID(), (Object)"f6b178ce445dc3ffaa06bad27a51fead");
        Assert.assertEquals((Object)this.findCommitter(streamGraph).getTransformationUID(), (Object)String.format("Sink Committer: %s", "f6b178ce445dc3ffaa06bad27a51fead"));
        Assert.assertEquals((Object)this.findGlobalCommitter(streamGraph).getTransformationUID(), (Object)String.format("Sink %s Global Committer", "f6b178ce445dc3ffaa06bad27a51fead"));
    }

    private void validateTopology(StreamNode src, Class<?> srcOutTypeInfo, StreamNode dest, Class<? extends StreamOperatorFactory> operatorFactoryClass, int expectedParallelism, int expectedMaxParallelism) {
        StreamEdge srcOutEdge = (StreamEdge)src.getOutEdges().get(0);
        MatcherAssert.assertThat((Object)srcOutEdge.getTargetId(), (Matcher)CoreMatchers.equalTo((Object)dest.getId()));
        MatcherAssert.assertThat((Object)src.getTypeSerializerOut(), (Matcher)CoreMatchers.instanceOf(srcOutTypeInfo));
        StreamEdge destInputEdge = (StreamEdge)dest.getInEdges().get(0);
        MatcherAssert.assertThat((Object)destInputEdge.getSourceId(), (Matcher)CoreMatchers.equalTo((Object)src.getId()));
        MatcherAssert.assertThat((Object)dest.getTypeSerializersIn()[0], (Matcher)CoreMatchers.instanceOf(srcOutTypeInfo));
        MatcherAssert.assertThat((Object)dest.getOperatorName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)src.getOperatorName())));
        MatcherAssert.assertThat((Object)dest.getTransformationUID(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)src.getTransformationUID())));
        MatcherAssert.assertThat((Object)dest.getOperatorFactory(), (Matcher)CoreMatchers.instanceOf(operatorFactoryClass));
        MatcherAssert.assertThat((Object)dest.getParallelism(), (Matcher)CoreMatchers.equalTo((Object)expectedParallelism));
        MatcherAssert.assertThat((Object)dest.getMaxParallelism(), (Matcher)CoreMatchers.equalTo((Object)expectedMaxParallelism));
        MatcherAssert.assertThat((Object)dest.getOperatorFactory().getChainingStrategy(), (Matcher)CoreMatchers.is((Object)ChainingStrategy.ALWAYS));
        MatcherAssert.assertThat((Object)dest.getSlotSharingGroup(), (Matcher)CoreMatchers.equalTo((Object)SLOT_SHARE_GROUP));
    }

    private StreamGraph buildGraph(TestSink sink, RuntimeExecutionMode runtimeExecutionMode) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        Configuration config = new Configuration();
        config.set(ExecutionOptions.RUNTIME_MODE, (Object)runtimeExecutionMode);
        env.configure((ReadableConfig)config, ((Object)((Object)this)).getClass().getClassLoader());
        DataStreamSource src = env.fromElements((Object[])new Integer[]{1, 2});
        DataStreamSink dataStreamSink = src.rebalance().sinkTo((Sink)sink);
        this.setSinkProperty((DataStreamSink<Integer>)dataStreamSink);
        env.getExecutionPlan();
        return env.getStreamGraph();
    }

    private void setSinkProperty(DataStreamSink<Integer> dataStreamSink) {
        dataStreamSink.name(NAME);
        dataStreamSink.uid(UID);
        dataStreamSink.setParallelism(2);
        dataStreamSink.slotSharingGroup(SLOT_SHARE_GROUP);
    }

    private StreamNode findNodeName(StreamGraph streamGraph, Predicate<String> predicate) {
        return streamGraph.getStreamNodes().stream().filter(node -> predicate.test(node.getOperatorName())).findFirst().orElseThrow(() -> new IllegalStateException("Can not find the node"));
    }
}

