/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.ExecutionConfigTest;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StreamExecutionEnvironmentConfigurationTest {
    @Parameterized.Parameter
    public TestSpec spec;

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestSpec> specs() {
        return Arrays.asList(TestSpec.testValue(TimeCharacteristic.IngestionTime).whenSetFromFile("pipeline.time-characteristic", "IngestionTime").viaSetter(StreamExecutionEnvironment::setStreamTimeCharacteristic).getterVia(StreamExecutionEnvironment::getStreamTimeCharacteristic).nonDefaultValue(TimeCharacteristic.EventTime), TestSpec.testValue(60000L).whenSetFromFile("execution.buffer-timeout", "1 min").viaSetter(StreamExecutionEnvironment::setBufferTimeout).getterVia(StreamExecutionEnvironment::getBufferTimeout).nonDefaultValue(12000L), TestSpec.testValue(false).whenSetFromFile("pipeline.operator-chaining", "false").viaSetter((env, b) -> {
            if (b.booleanValue()) {
                throw new IllegalArgumentException("Cannot programmatically enable operator chaining");
            }
            env.disableOperatorChaining();
        }).getterVia(StreamExecutionEnvironment::isChainingEnabled).nonDefaultValue(false), TestSpec.testValue(ExecutionConfig.ClosureCleanerLevel.TOP_LEVEL).whenSetFromFile("pipeline.closure-cleaner-level", "TOP_LEVEL").viaSetter((env, v) -> env.getConfig().setClosureCleanerLevel(v)).getterVia(env -> env.getConfig().getClosureCleanerLevel()).nonDefaultValue(ExecutionConfig.ClosureCleanerLevel.NONE), TestSpec.testValue(12000L).whenSetFromFile("execution.checkpointing.timeout", "12 s").viaSetter((env, v) -> env.getCheckpointConfig().setCheckpointTimeout(v.longValue())).getterVia(env -> env.getCheckpointConfig().getCheckpointTimeout()).nonDefaultValue(100L));
    }

    @Test
    public void testLoadingFromConfiguration() {
        StreamExecutionEnvironment configFromSetters = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamExecutionEnvironment configFromFile = StreamExecutionEnvironment.getExecutionEnvironment();
        Configuration configuration = new Configuration();
        configuration.setString(this.spec.key, this.spec.value);
        configFromFile.configure((ReadableConfig)configuration, ExecutionConfigTest.class.getClassLoader());
        this.spec.setValue(configFromSetters);
        this.spec.assertEqual(configFromFile, configFromSetters);
    }

    @Test
    public void testNotOverridingIfNotSet() {
        StreamExecutionEnvironment environment = StreamExecutionEnvironment.getExecutionEnvironment();
        this.spec.setNonDefaultValue(environment);
        Configuration configuration = new Configuration();
        environment.configure((ReadableConfig)configuration, ExecutionConfigTest.class.getClassLoader());
        this.spec.assertEqualNonDefault(environment);
    }

    private static class TestSpec<T> {
        private String key;
        private String value;
        private final T objectValue;
        private T nonDefaultValue;
        private BiConsumer<StreamExecutionEnvironment, T> setter;
        private Function<StreamExecutionEnvironment, T> getter;

        private TestSpec(T value) {
            this.objectValue = value;
        }

        public static <T> TestSpec<T> testValue(T value) {
            return new TestSpec<T>(value);
        }

        public TestSpec<T> whenSetFromFile(String key, String value) {
            this.key = key;
            this.value = value;
            return this;
        }

        public TestSpec<T> viaSetter(BiConsumer<StreamExecutionEnvironment, T> setter) {
            this.setter = setter;
            return this;
        }

        public TestSpec<T> getterVia(Function<StreamExecutionEnvironment, T> getter) {
            this.getter = getter;
            return this;
        }

        public TestSpec<T> nonDefaultValue(T nonDefaultValue) {
            this.nonDefaultValue = nonDefaultValue;
            return this;
        }

        public void setValue(StreamExecutionEnvironment config) {
            this.setter.accept(config, (StreamExecutionEnvironment)this.objectValue);
        }

        public void setNonDefaultValue(StreamExecutionEnvironment config) {
            this.setter.accept(config, (StreamExecutionEnvironment)this.nonDefaultValue);
        }

        public void assertEqual(StreamExecutionEnvironment configFromFile, StreamExecutionEnvironment configFromSetters) {
            Assert.assertThat(this.getter.apply(configFromFile), (Matcher)CoreMatchers.equalTo(this.getter.apply(configFromSetters)));
        }

        public void assertEqualNonDefault(StreamExecutionEnvironment configFromFile) {
            Assert.assertThat(this.getter.apply(configFromFile), (Matcher)CoreMatchers.equalTo(this.nonDefaultValue));
        }

        public String toString() {
            return "key='" + this.key + '\'';
        }
    }
}

