/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.connector.sink2;

import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apache.flink.streaming.api.connector.sink2.CommittableSummary;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public class CommittableSummaryAssert
extends AbstractAssert<CommittableSummaryAssert, CommittableSummary<?>> {
    public CommittableSummaryAssert(CommittableSummary<?> summary) {
        super(summary, CommittableSummaryAssert.class);
    }

    public CommittableSummaryAssert isEqualTo(CommittableSummary<?> summary) {
        this.isNotNull();
        Assertions.assertThat((int)((CommittableSummary)this.actual).getSubtaskId()).isEqualTo(summary.getSubtaskId());
        Assertions.assertThat((OptionalLong)((CommittableSummary)this.actual).getCheckpointId()).isEqualTo((Object)summary.getCheckpointId());
        Assertions.assertThat((int)((CommittableSummary)this.actual).getNumberOfCommittables()).isEqualTo(summary.getNumberOfCommittables());
        Assertions.assertThat((int)((CommittableSummary)this.actual).getNumberOfPendingCommittables()).isEqualTo(summary.getNumberOfPendingCommittables());
        Assertions.assertThat((int)((CommittableSummary)this.actual).getNumberOfFailedCommittables()).isEqualTo(summary.getNumberOfFailedCommittables());
        return this;
    }

    public CommittableSummaryAssert hasOverallCommittables(int committableNumber) {
        this.isNotNull();
        Assertions.assertThat((int)((CommittableSummary)this.actual).getNumberOfCommittables()).isEqualTo(committableNumber);
        return this;
    }

    public CommittableSummaryAssert hasPendingCommittables(int committableNumber) {
        this.isNotNull();
        Assertions.assertThat((int)((CommittableSummary)this.actual).getNumberOfPendingCommittables()).isEqualTo(committableNumber);
        return this;
    }

    public CommittableSummaryAssert hasFailedCommittables(int committableNumber) {
        this.isNotNull();
        Assertions.assertThat((int)((CommittableSummary)this.actual).getNumberOfFailedCommittables()).isEqualTo(committableNumber);
        return this;
    }

    public CommittableSummaryAssert hasCheckpointId(@Nullable Long checkpointId) {
        this.isNotNull();
        if (checkpointId == null) {
            Assertions.assertThat((OptionalLong)((CommittableSummary)this.actual).getCheckpointId()).isEmpty();
        } else {
            Assertions.assertThat((OptionalLong)((CommittableSummary)this.actual).getCheckpointId()).hasValue(checkpointId.longValue());
        }
        return this;
    }
}

