/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.json;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class JSONParser {
    private JSONObject originalJO;
    private String searchedfield;
    private Object temp;

    public JSONParser(String jsonText) throws JSONException {
        this.originalJO = new JSONObject(jsonText);
    }

    public JSONObject parse(String key) throws JSONException {
        this.initializeParser(key);
        this.parsing();
        return this.putResultInJSONObj();
    }

    private void initializeParser(String key) throws JSONException {
        this.searchedfield = key;
        this.temp = new JSONObject(this.originalJO.toString());
    }

    private void parsing() throws JSONException {
        StringTokenizer st = new StringTokenizer(this.searchedfield, ".");
        while (st.hasMoreTokens()) {
            this.find(st.nextToken());
        }
    }

    private void find(String nextToken) throws JSONException {
        if (this.endsWithBracket(nextToken)) {
            this.treatAllBracket(nextToken);
        } else {
            this.temp = ((JSONObject)this.temp).get(nextToken);
        }
    }

    private boolean endsWithBracket(String nextToken) {
        return nextToken.substring(nextToken.length() - 1).endsWith("]");
    }

    private void treatAllBracket(String nextToken) throws JSONException {
        List<String> list = Arrays.asList(nextToken.split("\\["));
        ListIterator<String> iter = list.listIterator();
        this.temp = ((JSONObject)this.temp).get(iter.next());
        while (iter.hasNext()) {
            int index = Integer.parseInt(this.cutBracket(iter.next()));
            this.temp = ((JSONArray)this.temp).get(index);
        }
    }

    private String cutBracket(String string) {
        return string.substring(0, string.length() - 1);
    }

    private JSONObject putResultInJSONObj() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("retValue", this.temp);
        return jo;
    }
}

