/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.twitter;

import java.util.StringTokenizer;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.connectors.json.JSONParseFlatMap;
import org.apache.flink.streaming.connectors.twitter.TwitterSource;
import org.apache.flink.streaming.examples.twitter.util.TwitterStreamData;
import org.apache.flink.util.Collector;
import org.apache.sling.commons.json.JSONException;

public class TwitterStream {
    private static boolean fileInput = false;
    private static boolean fileOutput = false;
    private static String propertiesPath;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!TwitterStream.parseParameters(args)) {
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStream<String> streamSource = TwitterStream.getTextDataStream(env);
        SingleOutputStreamOperator tweets = streamSource.flatMap((FlatMapFunction)new SelectEnglishAndTokenizeFlatMap()).groupBy(new int[]{0}).sum(1);
        if (fileOutput) {
            tweets.writeAsText(outputPath);
        } else {
            tweets.print();
        }
        env.execute("Twitter Streaming Example");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing TwitterStream example with built-in default data.");
            System.out.println("  Provide parameters to read input data from a file.");
            System.out.println("  USAGE: TwitterStream [<pathToPropertiesFile>] <result path>");
            return true;
        }
        fileOutput = true;
        if (args.length == 2) {
            fileInput = true;
            propertiesPath = args[0];
            outputPath = args[1];
            return true;
        }
        if (args.length == 1) {
            outputPath = args[0];
            return true;
        }
        System.err.println("USAGE:\nTwitterStream [<pathToPropertiesFile>] <result path>");
        return false;
    }

    private static DataStream<String> getTextDataStream(StreamExecutionEnvironment env) {
        if (fileInput) {
            return env.addSource((SourceFunction)new TwitterSource(propertiesPath));
        }
        return env.fromElements((Object[])TwitterStreamData.TEXTS);
    }

    public static class SelectEnglishAndTokenizeFlatMap
    extends JSONParseFlatMap<String, Tuple2<String, Integer>> {
        private static final long serialVersionUID = 1L;

        public void flatMap(String value, Collector<Tuple2<String, Integer>> out) throws Exception {
            try {
                if (this.getString(value, "user.lang").equals("en")) {
                    StringTokenizer tokenizer = new StringTokenizer(this.getString(value, "text"));
                    while (tokenizer.hasMoreTokens()) {
                        String result = tokenizer.nextToken().replaceAll("\\s*", "").toLowerCase();
                        if (result == null || result.equals("")) continue;
                        out.collect((Object)new Tuple2((Object)result, (Object)1));
                    }
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }
}

