/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.scala.examples.join;

import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.scala.StreamJoinOperator;
import org.apache.flink.streaming.scala.examples.join.WindowJoin;
import org.apache.flink.streaming.scala.examples.join.WindowJoin$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class WindowJoin$ {
    public static final WindowJoin$ MODULE$;
    private final String[] names;
    private final int gradeCount;
    private final int salaryMax;
    private final int sleepInterval;
    private boolean fileInput;
    private boolean fileOutput;
    private String gradesPath;
    private String salariesPath;
    private String outputPath;

    static {
        new WindowJoin$();
    }

    public void main(String[] args) {
        if (this.parseParameters(args)) {
            StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
            DataStream<WindowJoin.Grade> grades = this.setGradesInput(env);
            DataStream<WindowJoin.Salary> salaries = this.setSalariesInput(env);
            DataStream joined = ((StreamJoinOperator.JoinWindow)grades.join(salaries).onWindow(2L, TimeUnit.SECONDS)).every(1L, TimeUnit.SECONDS).where("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).equalTo("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).apply((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final WindowJoin.Person apply(WindowJoin.Grade g, WindowJoin.Salary s) {
                    return new WindowJoin.Person(g.name(), g.grade(), s.salary());
                }
            }, (TypeInformation)new CaseClassTypeInfo<WindowJoin.Person>(){

                public TypeInformation<?>[] protected$types(anon.10 x$1) {
                    return x$1.types;
                }

                public Class<WindowJoin.Person> protected$tupleType(anon.10 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<WindowJoin.Person> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.10 $outer;
                        private final ExecutionConfig executionConfig$1;
                        private final TypeSerializer[] fieldSerializers$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$1 = executionConfig$1;
                            this.fieldSerializers$1 = fieldSerializers$1;
                        }
                    });
                    return new CaseClassSerializer<WindowJoin.Person>(this, fieldSerializers){

                        public WindowJoin.Person createInstance(Object[] fields) {
                            return new WindowJoin.Person((String)fields[0], BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToInt((Object)fields[2]));
                        }
                    };
                }
            }, ClassTag$.MODULE$.apply(WindowJoin.Person.class));
            DataStream dataStream = this.fileOutput() ? joined.writeAsText(this.outputPath(), joined.writeAsText$default$2()) : joined.print();
            env.execute("WindowJoin");
            return;
        }
    }

    public String[] names() {
        return this.names;
    }

    public int gradeCount() {
        return this.gradeCount;
    }

    public int salaryMax() {
        return this.salaryMax;
    }

    public int sleepInterval() {
        return this.sleepInterval;
    }

    public Stream<Tuple2<String, Object>> gradeStream() {
        return (Stream)((Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(int x) {
                return WindowJoin$.MODULE$.org$apache$flink$streaming$scala$examples$join$WindowJoin$$gradeMapper$1(WindowJoin$.MODULE$.names(), x);
            }
        }, package$.MODULE$.Stream().canBuildFrom());
    }

    public Stream<Tuple2<String, Object>> salaryStream() {
        return (Stream)((Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)100), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(int x) {
                return WindowJoin$.MODULE$.org$apache$flink$streaming$scala$examples$join$WindowJoin$$salaryMapper$1(x);
            }
        }, package$.MODULE$.Stream().canBuildFrom());
    }

    public Tuple2<String, Object> parseMap(String line) {
        String[] record = line.substring(1, line.length() - 1).split(",");
        return new Tuple2((Object)record[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(record[1])).toInt()));
    }

    private boolean fileInput() {
        return this.fileInput;
    }

    private void fileInput_$eq(boolean x$1) {
        this.fileInput = x$1;
    }

    private boolean fileOutput() {
        return this.fileOutput;
    }

    private void fileOutput_$eq(boolean x$1) {
        this.fileOutput = x$1;
    }

    private String gradesPath() {
        return this.gradesPath;
    }

    private void gradesPath_$eq(String x$1) {
        this.gradesPath = x$1;
    }

    private String salariesPath() {
        return this.salariesPath;
    }

    private void salariesPath_$eq(String x$1) {
        this.salariesPath = x$1;
    }

    private String outputPath() {
        return this.outputPath;
    }

    private void outputPath_$eq(String x$1) {
        this.outputPath = x$1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing WindowJoin with generated data.");
            System.out.println("  Provide parameter to write to file.");
            System.out.println("  Usage: WindowJoin <result path>");
            return true;
        }
        if (args.length == 1) {
            this.fileOutput_$eq(true);
            this.outputPath_$eq(args[0]);
            return true;
        }
        if (args.length == 3) {
            this.fileInput_$eq(true);
            this.fileOutput_$eq(true);
            this.gradesPath_$eq(args[0]);
            this.salariesPath_$eq(args[1]);
            this.outputPath_$eq(args[2]);
            return true;
        }
        System.err.println("Usage: WindowJoin <result path> or WindowJoin <input path 1> <input path 2> <result path>");
        return false;
    }

    private DataStream<WindowJoin.Grade> setGradesInput(StreamExecutionEnvironment env) {
        return this.fileInput() ? env.readTextFile(this.gradesPath()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String x$1) {
                return WindowJoin$.MODULE$.parseMap(x$1);
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(){

            public TypeInformation<?>[] protected$types(anon.11 x$1) {
                return x$1.types;
            }

            public Class<Tuple2<String, Object>> protected$tupleType(anon.11 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.11 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                return new CaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final WindowJoin.Grade apply(Tuple2<String, Object> x) {
                return new WindowJoin.Grade((String)x._1(), x._2$mcI$sp());
            }
        }, (TypeInformation)new CaseClassTypeInfo<WindowJoin.Grade>(){

            public TypeInformation<?>[] protected$types(anon.12 x$1) {
                return x$1.types;
            }

            public Class<WindowJoin.Grade> protected$tupleType(anon.12 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<WindowJoin.Grade> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.12 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                return new CaseClassSerializer<WindowJoin.Grade>(this, fieldSerializers){

                    public WindowJoin.Grade createInstance(Object[] fields) {
                        return new WindowJoin.Grade((String)fields[0], BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(WindowJoin.Grade.class)) : env.fromCollection(this.gradeStream(), ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(){

            public TypeInformation<?>[] protected$types(anon.13 x$1) {
                return x$1.types;
            }

            public Class<Tuple2<String, Object>> protected$tupleType(anon.13 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.13 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                return new CaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final WindowJoin.Grade apply(Tuple2<String, Object> x) {
                return new WindowJoin.Grade((String)x._1(), x._2$mcI$sp());
            }
        }, (TypeInformation)new CaseClassTypeInfo<WindowJoin.Grade>(){

            public TypeInformation<?>[] protected$types(anon.14 x$1) {
                return x$1.types;
            }

            public Class<WindowJoin.Grade> protected$tupleType(anon.14 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<WindowJoin.Grade> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.14 $outer;
                    private final ExecutionConfig executionConfig$5;
                    private final TypeSerializer[] fieldSerializers$5;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$5 = executionConfig$5;
                        this.fieldSerializers$5 = fieldSerializers$5;
                    }
                });
                return new CaseClassSerializer<WindowJoin.Grade>(this, fieldSerializers){

                    public WindowJoin.Grade createInstance(Object[] fields) {
                        return new WindowJoin.Grade((String)fields[0], BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(WindowJoin.Grade.class));
    }

    private DataStream<WindowJoin.Salary> setSalariesInput(StreamExecutionEnvironment env) {
        return this.fileInput() ? env.readTextFile(this.salariesPath()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String x$2) {
                return WindowJoin$.MODULE$.parseMap(x$2);
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(){

            public TypeInformation<?>[] protected$types(anon.15 x$1) {
                return x$1.types;
            }

            public Class<Tuple2<String, Object>> protected$tupleType(anon.15 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.15 $outer;
                    private final ExecutionConfig executionConfig$6;
                    private final TypeSerializer[] fieldSerializers$6;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$6 = executionConfig$6;
                        this.fieldSerializers$6 = fieldSerializers$6;
                    }
                });
                return new CaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final WindowJoin.Salary apply(Tuple2<String, Object> x) {
                return new WindowJoin.Salary((String)x._1(), x._2$mcI$sp());
            }
        }, (TypeInformation)new CaseClassTypeInfo<WindowJoin.Salary>(){

            public TypeInformation<?>[] protected$types(anon.16 x$1) {
                return x$1.types;
            }

            public Class<WindowJoin.Salary> protected$tupleType(anon.16 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<WindowJoin.Salary> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.16 $outer;
                    private final ExecutionConfig executionConfig$7;
                    private final TypeSerializer[] fieldSerializers$7;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$7 = executionConfig$7;
                        this.fieldSerializers$7 = fieldSerializers$7;
                    }
                });
                return new CaseClassSerializer<WindowJoin.Salary>(this, fieldSerializers){

                    public WindowJoin.Salary createInstance(Object[] fields) {
                        return new WindowJoin.Salary((String)fields[0], BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(WindowJoin.Salary.class)) : env.fromCollection(this.salaryStream(), ClassTag$.MODULE$.apply(Tuple2.class), (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(){

            public TypeInformation<?>[] protected$types(anon.17 x$1) {
                return x$1.types;
            }

            public Class<Tuple2<String, Object>> protected$tupleType(anon.17 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.17 $outer;
                    private final ExecutionConfig executionConfig$8;
                    private final TypeSerializer[] fieldSerializers$8;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$8[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$8);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$8 = executionConfig$8;
                        this.fieldSerializers$8 = fieldSerializers$8;
                    }
                });
                return new CaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final WindowJoin.Salary apply(Tuple2<String, Object> x) {
                return new WindowJoin.Salary((String)x._1(), x._2$mcI$sp());
            }
        }, (TypeInformation)new CaseClassTypeInfo<WindowJoin.Salary>(){

            public TypeInformation<?>[] protected$types(anon.18 x$1) {
                return x$1.types;
            }

            public Class<WindowJoin.Salary> protected$tupleType(anon.18 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<WindowJoin.Salary> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.18 $outer;
                    private final ExecutionConfig executionConfig$9;
                    private final TypeSerializer[] fieldSerializers$9;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$9[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$9);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$9 = executionConfig$9;
                        this.fieldSerializers$9 = fieldSerializers$9;
                    }
                });
                return new CaseClassSerializer<WindowJoin.Salary>(this, fieldSerializers){

                    public WindowJoin.Salary createInstance(Object[] fields) {
                        return new WindowJoin.Salary((String)fields[0], BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(WindowJoin.Salary.class));
    }

    public final Tuple2 org$apache$flink$streaming$scala$examples$join$WindowJoin$$gradeMapper$1(String[] names, int x) {
        if (x % this.sleepInterval() == 0) {
            Thread.sleep(this.sleepInterval());
        }
        return new Tuple2((Object)names[Random$.MODULE$.nextInt(names.length)], (Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(this.gradeCount())));
    }

    public final Tuple2 org$apache$flink$streaming$scala$examples$join$WindowJoin$$salaryMapper$1(int x) {
        if (x % this.sleepInterval() == 0) {
            Thread.sleep(this.sleepInterval());
        }
        return new Tuple2((Object)this.names()[Random$.MODULE$.nextInt(this.names().length)], (Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(this.salaryMax())));
    }

    private WindowJoin$() {
        MODULE$ = this;
        this.names = (String[])((Object[])new String[]{"tom", "jerry", "alice", "bob", "john", "grace"});
        this.gradeCount = 5;
        this.salaryMax = 10000;
        this.sleepInterval = 100;
        this.fileInput = false;
        this.fileOutput = false;
        this.gradesPath = null;
        this.salariesPath = null;
        this.outputPath = null;
    }
}

