/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.iteration;

import java.util.ArrayList;
import java.util.Random;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;
import org.apache.flink.streaming.api.datastream.IterativeDataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.datastream.SplitDataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.function.source.SourceFunction;
import org.apache.flink.util.Collector;

public class IterateExample {
    private static final int BOUND = 100;
    private static boolean fileInput = false;
    private static boolean fileOutput = false;
    private static String inputPath;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!IterateExample.parseParameters(args)) {
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment().setBufferTimeout(1L);
        Object inputStream = fileInput ? env.readTextFile(inputPath).map((MapFunction)new FibonacciInputMap()) : env.addSource((SourceFunction)new RandomFibonacciSource());
        IterativeDataStream it = inputStream.map((MapFunction)new InputMap()).iterate(5000L);
        SplitDataStream step = it.map((MapFunction)new Step()).split((OutputSelector)new MySelector());
        it.closeWith(step.select(new String[]{"iterate"}));
        SingleOutputStreamOperator numbers = step.select(new String[]{"output"}).map((MapFunction)new OutputMap());
        if (fileOutput) {
            numbers.writeAsText(outputPath, 1L);
        } else {
            numbers.print();
        }
        env.execute("Streaming Iteration Example");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing IterateExample with generated data.");
            System.out.println("  Provide parameter to write to file.");
            System.out.println("  Usage: IterateExample <result path>");
            return true;
        }
        if (args.length == 1) {
            fileOutput = true;
            outputPath = args[0];
            return true;
        }
        if (args.length == 2) {
            fileInput = true;
            inputPath = args[0];
            fileOutput = true;
            outputPath = args[1];
            return true;
        }
        System.err.println("Usage: IterateExample <result path>");
        return false;
    }

    public static class OutputMap
    implements MapFunction<Tuple5<Integer, Integer, Integer, Integer, Integer>, Tuple2<Tuple2<Integer, Integer>, Integer>> {
        private static final long serialVersionUID = 1L;

        public Tuple2<Tuple2<Integer, Integer>, Integer> map(Tuple5<Integer, Integer, Integer, Integer, Integer> value) throws Exception {
            return new Tuple2((Object)new Tuple2(value.f0, value.f1), value.f4);
        }
    }

    public static class MySelector
    implements OutputSelector<Tuple5<Integer, Integer, Integer, Integer, Integer>> {
        private static final long serialVersionUID = 1L;

        public Iterable<String> select(Tuple5<Integer, Integer, Integer, Integer, Integer> value) {
            ArrayList<String> output = new ArrayList<String>();
            if ((Integer)value.f2 < 100 && (Integer)value.f3 < 100) {
                output.add("iterate");
            } else {
                output.add("output");
            }
            return output;
        }
    }

    public static class Step
    implements MapFunction<Tuple5<Integer, Integer, Integer, Integer, Integer>, Tuple5<Integer, Integer, Integer, Integer, Integer>> {
        private static final long serialVersionUID = 1L;

        public Tuple5<Integer, Integer, Integer, Integer, Integer> map(Tuple5<Integer, Integer, Integer, Integer, Integer> value) throws Exception {
            Tuple5<Integer, Integer, Integer, Integer, Integer> tuple5 = value;
            tuple5.f4 = (Integer)tuple5.f4 + 1;
            return new Tuple5(value.f0, value.f1, value.f3, (Object)((Integer)value.f2 + (Integer)value.f3), tuple5.f4);
        }
    }

    public static class InputMap
    implements MapFunction<Tuple2<Integer, Integer>, Tuple5<Integer, Integer, Integer, Integer, Integer>> {
        private static final long serialVersionUID = 1L;

        public Tuple5<Integer, Integer, Integer, Integer, Integer> map(Tuple2<Integer, Integer> value) throws Exception {
            return new Tuple5(value.f0, value.f1, value.f0, value.f1, (Object)0);
        }
    }

    private static class FibonacciInputMap
    implements MapFunction<String, Tuple2<Integer, Integer>> {
        private static final long serialVersionUID = 1L;

        private FibonacciInputMap() {
        }

        public Tuple2<Integer, Integer> map(String value) throws Exception {
            String record = value.substring(1, value.length() - 1);
            String[] splitted = record.split(",");
            return new Tuple2((Object)Integer.parseInt(splitted[0]), (Object)Integer.parseInt(splitted[1]));
        }
    }

    private static class RandomFibonacciSource
    implements SourceFunction<Tuple2<Integer, Integer>> {
        private static final long serialVersionUID = 1L;
        private Random rnd = new Random();

        private RandomFibonacciSource() {
        }

        public void run(Collector<Tuple2<Integer, Integer>> collector) throws Exception {
            while (true) {
                int first = this.rnd.nextInt(49) + 1;
                int second = this.rnd.nextInt(49) + 1;
                collector.collect((Object)new Tuple2((Object)first, (Object)second));
                Thread.sleep(500L);
            }
        }

        public void cancel() {
        }
    }
}

