/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.windowing;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.examples.java.wordcount.util.WordCountData;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.windowing.helper.Count;
import org.apache.flink.streaming.api.windowing.helper.WindowingHelper;
import org.apache.flink.streaming.examples.wordcount.WordCount;

public class WindowWordCount {
    private static int windowSize = 250;
    private static int slideSize = 150;
    private static boolean fileOutput = false;
    private static String textPath;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!WindowWordCount.parseParameters(args)) {
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStream<String> text = WindowWordCount.getTextDataStream(env);
        DataStream counts = text.flatMap((FlatMapFunction)new WordCount.Tokenizer()).window((WindowingHelper)Count.of((int)windowSize)).every((WindowingHelper)Count.of((int)slideSize)).groupBy(new int[]{0}).sum(1).flatten();
        if (fileOutput) {
            counts.writeAsText(outputPath);
        } else {
            counts.print();
        }
        env.execute("WindowWordCount");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing WindowWordCount example with built-in default data.");
            System.out.println("  Provide parameters to read input data from a file.");
            System.out.println("  Usage: WindowWordCount <text path> <result path> [<window size>] [<slide size>]");
            return true;
        }
        fileOutput = true;
        if (args.length >= 2 && args.length <= 4) {
            textPath = args[0];
            outputPath = args[1];
            if (args.length < 3) return true;
            windowSize = Integer.parseInt(args[2]);
            slideSize = args.length == 3 ? windowSize : Integer.parseInt(args[2]);
            return true;
        }
        System.err.println("Usage: WindowWordCount <text path> <result path> [<window size>] [<slide size>]");
        return false;
    }

    private static DataStream<String> getTextDataStream(StreamExecutionEnvironment env) {
        if (fileOutput) {
            return env.readTextFile(textPath);
        }
        return env.fromElements((Object[])WordCountData.WORDS);
    }
}

