/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.socket;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.examples.wordcount.WordCount;

public class SocketTextStreamWordCount {
    private static boolean fileOutput = false;
    private static String hostName;
    private static int port;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!SocketTextStreamWordCount.parseParameters(args)) {
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource text = env.socketTextStream(hostName, port);
        SingleOutputStreamOperator counts = text.flatMap((FlatMapFunction)new WordCount.Tokenizer()).groupBy(new int[]{0}).sum(1);
        if (fileOutput) {
            counts.writeAsText(outputPath, 1L);
        } else {
            counts.print();
        }
        env.execute("WordCount from SocketTextStream Example");
    }

    private static boolean parseParameters(String[] args) {
        if (args.length == 3) {
            fileOutput = true;
            hostName = args[0];
            port = Integer.valueOf(args[1]);
            outputPath = args[2];
        } else if (args.length == 2) {
            hostName = args[0];
            port = Integer.valueOf(args[1]);
        } else {
            System.err.println("Usage: SocketTextStreamWordCount <hostname> <port> [<output path>]");
            return false;
        }
        return true;
    }
}

