/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.iteration;

import java.util.ArrayList;
import java.util.Random;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.collector.OutputSelector;
import org.apache.flink.streaming.api.datastream.IterativeDataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.datastream.SplitDataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

public class IterateExample {
    private static boolean fileOutput = false;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!IterateExample.parseParameters(args)) {
            return;
        }
        ArrayList<Tuple2> input = new ArrayList<Tuple2>();
        for (int i = 0; i < 1000; ++i) {
            input.add(new Tuple2((Object)0.0, (Object)0));
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment().setBufferTimeout(1L);
        IterativeDataStream it = env.fromCollection(input).shuffle().iterate(5000L);
        SplitDataStream step = it.map((MapFunction)new Step()).shuffle().split((OutputSelector)new MySelector());
        it.closeWith(step.select(new String[]{"iterate"}));
        SingleOutputStreamOperator numbers = step.select(new String[]{"output"}).project(new int[]{1}).types(Integer.class);
        if (fileOutput) {
            numbers.writeAsText(outputPath, 1L);
        } else {
            numbers.print();
        }
        env.execute("Streaming Iteration Example");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing IterateExample with generated data.");
            System.out.println("  Provide parameter to write to file.");
            System.out.println("  Usage: IterateExample <result path>");
            return true;
        }
        fileOutput = true;
        if (args.length == 1) {
            outputPath = args[0];
            return true;
        }
        System.err.println("Usage: IterateExample <result path>");
        return false;
    }

    public static class MySelector
    implements OutputSelector<Tuple2<Double, Integer>> {
        private static final long serialVersionUID = 1L;

        public Iterable<String> select(Tuple2<Double, Integer> value) {
            ArrayList<String> output = new ArrayList<String>();
            if ((Double)value.f0 > 100.0) {
                output.add("output");
            } else {
                output.add("iterate");
            }
            return output;
        }
    }

    public static class Step
    extends RichMapFunction<Tuple2<Double, Integer>, Tuple2<Double, Integer>> {
        private static final long serialVersionUID = 1L;
        private transient Random rnd;

        public void open(Configuration parameters) {
            this.rnd = new Random();
        }

        public Tuple2<Double, Integer> map(Tuple2<Double, Integer> value) throws Exception {
            return new Tuple2((Object)((Double)value.f0 + this.rnd.nextDouble()), (Object)((Integer)value.f1 + 1));
        }
    }
}

