/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.windowing;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.function.source.RichSourceFunction;
import org.apache.flink.streaming.api.function.source.SourceFunction;
import org.apache.flink.streaming.api.windowing.helper.Count;
import org.apache.flink.streaming.api.windowing.helper.Time;
import org.apache.flink.streaming.api.windowing.helper.WindowingHelper;
import org.apache.flink.util.Collector;

public class TimeWindowingExample {
    private static boolean fileOutput = false;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!TimeWindowingExample.parseParameters(args)) {
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        SingleOutputStreamOperator stream = env.addSource((SourceFunction)new CountingSourceWithSleep()).window(new WindowingHelper[]{Count.of((int)100)}).every(new WindowingHelper[]{Time.of((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS)}).groupBy((KeySelector)new MyKey()).sum(0);
        if (fileOutput) {
            stream.writeAsText(outputPath, 1L);
        } else {
            stream.print();
        }
        env.execute("Time Windowing Example");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing TimeWindowingExample with generated data.");
            System.out.println("  Provide parameter to write to file.");
            System.out.println("  Usage: TimeWindowingExample <result path>");
            return true;
        }
        fileOutput = true;
        if (args.length == 1) {
            outputPath = args[0];
            return true;
        }
        System.err.println("Usage: TimeWindowingExample <result path>");
        return false;
    }

    private static final class MyKey
    implements KeySelector<Integer, Integer> {
        private static final long serialVersionUID = 1L;

        private MyKey() {
        }

        public Integer getKey(Integer value) throws Exception {
            if (value < 2) {
                return 0;
            }
            return 1;
        }
    }

    private static final class CountingSourceWithSleep
    extends RichSourceFunction<Integer> {
        private static final long serialVersionUID = 1L;
        private int counter = 0;
        private transient Random rnd;

        private CountingSourceWithSleep() {
        }

        public void open(Configuration parameters) throws Exception {
            super.open(parameters);
            this.rnd = new Random();
        }

        public void invoke(Collector<Integer> collector) throws Exception {
            while (true) {
                if (this.counter > 9999) {
                    System.out.println("Source pauses now!");
                    Thread.sleep(5000L);
                    System.out.println("Source continouse with emitting now!");
                    this.counter = 0;
                }
                collector.collect((Object)(this.rnd.nextInt(9) + 1));
                Thread.sleep(1L);
                ++this.counter;
            }
        }
    }
}

