/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.scala.examples.windowing;

import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.scala.windowing.Delta$;
import org.apache.flink.streaming.api.scala.windowing.Time$;
import org.apache.flink.streaming.api.windowing.helper.WindowingHelper;
import org.apache.flink.streaming.scala.examples.windowing.TopSpeedWindowing;
import org.apache.flink.streaming.scala.examples.windowing.TopSpeedWindowing$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class TopSpeedWindowing$ {
    public static final TopSpeedWindowing$ MODULE$;
    private int numOfCars;
    private int evictionSec;
    private double triggerMeters;

    static {
        new TopSpeedWindowing$();
    }

    public void main(String[] args) {
        if (this.parseParameters(args)) {
            StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
            DataStream cars = env.fromCollection(this.genCarStream(), ClassTag$.MODULE$.apply(TopSpeedWindowing.CarEvent.class), (TypeInformation)new CaseClassTypeInfo<TopSpeedWindowing.CarEvent>(){

                public TypeInformation<?>[] protected$types(anon.1 x$1) {
                    return x$1.types;
                }

                public Class<TopSpeedWindowing.CarEvent> protected$tupleType(anon.1 x$1) {
                    return x$1.tupleType;
                }

                public TypeSerializer<TopSpeedWindowing.CarEvent> createSerializer() {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.1 $outer;
                        private final TypeSerializer[] fieldSerializers$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.fieldSerializers$1 = fieldSerializers$1;
                        }
                    });
                    return new CaseClassSerializer<TopSpeedWindowing.CarEvent>(this, fieldSerializers){

                        public TopSpeedWindowing.CarEvent createInstance(Object[] fields) {
                            return new TopSpeedWindowing.CarEvent(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]), BoxesRunTime.unboxToLong((Object)fields[3]));
                        }
                    };
                }
            }).groupBy("carId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).window((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WindowingHelper[]{Time$.MODULE$.of((long)this.evictionSec(), TimeUnit.SECONDS)})).every((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WindowingHelper[]{Delta$.MODULE$.of(this.triggerMeters(), (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(TopSpeedWindowing.CarEvent oldSp, TopSpeedWindowing.CarEvent newSp) {
                    return newSp.distance() - oldSp.distance();
                }
            }, (Object)new TopSpeedWindowing.CarEvent(0, 0, 0.0, 0L))})).reduce((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final TopSpeedWindowing.CarEvent apply(TopSpeedWindowing.CarEvent x, TopSpeedWindowing.CarEvent y) {
                    return x.speed() > y.speed() ? x : y;
                }
            });
            cars.print();
            env.execute("TopSpeedWindowing");
            return;
        }
    }

    public Stream<TopSpeedWindowing.CarEvent> genCarStream() {
        return this.org$apache$flink$streaming$scala$examples$windowing$TopSpeedWindowing$$carStream$1((Stream)((Stream)scala.package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)this.numOfCars()), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TopSpeedWindowing.CarEvent apply(int x$1) {
                return new TopSpeedWindowing.CarEvent(x$1, 50, 0.0, System.currentTimeMillis());
            }
        }, scala.package$.MODULE$.Stream().canBuildFrom()));
    }

    public boolean parseParameters(String[] args) {
        Object object;
        if (args.length > 0) {
            if (args.length == 3) {
                this.numOfCars_$eq(new StringOps(Predef$.MODULE$.augmentString(args[0])).toInt());
                this.evictionSec_$eq(new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt());
                this.triggerMeters_$eq(new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble());
                object = BoxedUnit.UNIT;
            } else {
                System.err.println("Usage: TopSpeedWindowing <numCars> <evictSec> <triggerMeters>");
                object = BoxesRunTime.boxToBoolean((boolean)false);
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return true;
    }

    public int numOfCars() {
        return this.numOfCars;
    }

    public void numOfCars_$eq(int x$1) {
        this.numOfCars = x$1;
    }

    public int evictionSec() {
        return this.evictionSec;
    }

    public void evictionSec_$eq(int x$1) {
        this.evictionSec = x$1;
    }

    public double triggerMeters() {
        return this.triggerMeters;
    }

    public void triggerMeters_$eq(double x$1) {
        this.triggerMeters = x$1;
    }

    public final TopSpeedWindowing.CarEvent org$apache$flink$streaming$scala$examples$windowing$TopSpeedWindowing$$nextSpeed$1(TopSpeedWindowing.CarEvent carEvent) {
        int next = Random$.MODULE$.nextBoolean() ? package$.MODULE$.min(100, carEvent.speed() + 5) : package$.MODULE$.max(0, carEvent.speed() - 5);
        return new TopSpeedWindowing.CarEvent(carEvent.carId(), next, carEvent.distance() + (double)next / 3.6, System.currentTimeMillis());
    }

    public final Stream org$apache$flink$streaming$scala$examples$windowing$TopSpeedWindowing$$carStream$1(Stream speeds) {
        Thread.sleep(1000L);
        return speeds.append((Function0)new Serializable(speeds){
            public static final long serialVersionUID = 0L;
            private final Stream speeds$1;

            public final Stream<TopSpeedWindowing.CarEvent> apply() {
                return TopSpeedWindowing$.MODULE$.org$apache$flink$streaming$scala$examples$windowing$TopSpeedWindowing$$carStream$1((Stream)this.speeds$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TopSpeedWindowing.CarEvent apply(TopSpeedWindowing.CarEvent carEvent) {
                        return TopSpeedWindowing$.MODULE$.org$apache$flink$streaming$scala$examples$windowing$TopSpeedWindowing$$nextSpeed$1(carEvent);
                    }
                }, scala.package$.MODULE$.Stream().canBuildFrom()));
            }
            {
                this.speeds$1 = speeds$1;
            }
        });
    }

    private TopSpeedWindowing$() {
        MODULE$ = this;
        this.numOfCars = 2;
        this.evictionSec = 10;
        this.triggerMeters = 50.0;
    }
}

