/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.windowing;

import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.function.source.SourceFunction;
import org.apache.flink.streaming.api.windowing.helper.Count;
import org.apache.flink.streaming.api.windowing.helper.WindowingHelper;
import org.apache.flink.util.Collector;

public class SlidingExample {
    private static boolean fileOutput = false;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!SlidingExample.parseParameters(args)) {
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        SingleOutputStreamOperator stream = env.addSource((SourceFunction)new CountingSource()).window(new WindowingHelper[]{Count.of((int)5).withDelete(4)}).every(new WindowingHelper[]{Count.of((int)4).startingAt(-1)}).reduce((ReduceFunction)new Concat());
        if (fileOutput) {
            stream.writeAsText(outputPath, 1L);
        } else {
            stream.print();
        }
        env.execute("Sliding Example");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing SlidingExample with generated data.");
            System.out.println("  Provide parameter to write to file.");
            System.out.println("  Usage: SlidingExample <result path>");
            return true;
        }
        fileOutput = true;
        if (args.length == 1) {
            outputPath = args[0];
            return true;
        }
        System.err.println("Usage: SlidingExample <result path>");
        return false;
    }

    private static final class Concat
    implements ReduceFunction<String> {
        private static final long serialVersionUID = 1L;

        private Concat() {
        }

        public String reduce(String value1, String value2) throws Exception {
            return value1 + "|" + value2;
        }
    }

    private static final class CountingSource
    implements SourceFunction<String> {
        private static final long serialVersionUID = 1L;
        private int counter = 0;

        private CountingSource() {
        }

        public void invoke(Collector<String> collector) throws Exception {
            while (true) {
                if (this.counter > 9999) {
                    this.counter = 0;
                }
                collector.collect((Object)("V" + this.counter++));
            }
        }
    }
}

