/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.windowing;

import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.function.source.SourceFunction;
import org.apache.flink.streaming.api.windowing.helper.Count;
import org.apache.flink.streaming.api.windowing.helper.WindowingHelper;
import org.apache.flink.util.Collector;

public class MultiplePoliciesExample {
    private static boolean fileOutput = false;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!MultiplePoliciesExample.parseParameters(args)) {
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        SingleOutputStreamOperator stream = env.addSource((SourceFunction)new BasicSource()).groupBy((KeySelector)new KeySelector<String, String>(){
            private static final long serialVersionUID = 1L;

            public String getKey(String value) throws Exception {
                return value;
            }
        }).window(new WindowingHelper[]{Count.of((int)2)}).every(new WindowingHelper[]{Count.of((int)3), Count.of((int)5)}).reduceGroup((GroupReduceFunction)new Concat());
        if (fileOutput) {
            stream.writeAsText(outputPath, 1L);
        } else {
            stream.print();
        }
        env.execute("Multiple Policies Example");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing MultiplePoliciesExample with generated data.");
            System.out.println("  Provide parameter to write to file.");
            System.out.println("  Usage: MultiplePoliciesExample <result path>");
            return true;
        }
        fileOutput = true;
        if (args.length == 1) {
            outputPath = args[0];
            return true;
        }
        System.err.println("Usage: MultiplePoliciesExample <result path>");
        return false;
    }

    public static final class Concat
    implements GroupReduceFunction<String, String> {
        private static final long serialVersionUID = 1L;

        public void reduce(Iterable<String> values, Collector<String> out) throws Exception {
            String output = "|";
            for (String v : values) {
                output = output + v + "|";
            }
            out.collect((Object)output);
        }
    }

    public static final class BasicSource
    implements SourceFunction<String> {
        private static final long serialVersionUID = 1L;
        private static final String STR_1 = new String("streaming");
        private static final String STR_2 = new String("flink");

        public void invoke(Collector<String> out) throws Exception {
            while (true) {
                out.collect((Object)STR_1);
                out.collect((Object)STR_2);
            }
        }
    }
}

