/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.twitter;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.connectors.json.JSONParseFlatMap;
import org.apache.flink.streaming.examples.twitter.util.TwitterStreamData;
import org.apache.flink.util.Collector;
import org.apache.sling.commons.json.JSONException;

public class TwitterStream {
    private static boolean fileOutput = false;
    private static String textPath;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!TwitterStream.parseParameters(args)) {
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setBufferTimeout(1000L);
        DataStream<String> streamSource = TwitterStream.getTextDataStream(env);
        SingleOutputStreamOperator tweets = streamSource.flatMap((FlatMapFunction)new SelectEnglishAndTokenizeFlatMap()).map((MapFunction)new MapFunction<String, Tuple2<String, Integer>>(){
            private static final long serialVersionUID = 1L;

            public Tuple2<String, Integer> map(String value) throws Exception {
                return new Tuple2((Object)value, (Object)1);
            }
        }).groupBy(new int[]{0}).sum(1).flatMap((FlatMapFunction)new SelectMaxOccurence());
        if (fileOutput) {
            tweets.writeAsText(outputPath, 1L);
        } else {
            tweets.print();
        }
        env.execute("Twitter Streaming Example");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing TwitterStream example with built-in default data.");
            System.out.println("  Provide parameters to read input data from a file.");
            System.out.println("  USAGE: TwitterStream <pathToPropertiesFile>");
            return true;
        }
        fileOutput = true;
        if (args.length == 2) {
            textPath = args[0];
            outputPath = args[1];
            return true;
        }
        System.err.println("USAGE:\nTwitterStream <pathToPropertiesFile> <result path>");
        return false;
    }

    private static DataStream<String> getTextDataStream(StreamExecutionEnvironment env) {
        if (fileOutput) {
            return env.readTextFile(textPath);
        }
        return env.fromElements((Serializable[])TwitterStreamData.TEXTS);
    }

    public static class SelectMaxOccurence
    implements FlatMapFunction<Tuple2<String, Integer>, Tuple2<String, Integer>> {
        private static final long serialVersionUID = 1L;
        private Integer maximum = 0;

        public void flatMap(Tuple2<String, Integer> value, Collector<Tuple2<String, Integer>> out) throws Exception {
            if ((Integer)value.getField(1) >= this.maximum) {
                out.collect(value);
                this.maximum = (Integer)value.getField(1);
            }
        }
    }

    public static class SelectEnglishAndTokenizeFlatMap
    extends JSONParseFlatMap<String, String> {
        private static final long serialVersionUID = 1L;

        public void flatMap(String value, Collector<String> out) throws Exception {
            try {
                if (this.getString(value, "lang").equals("en")) {
                    StringTokenizer tokenizer = new StringTokenizer(this.getString(value, "text"));
                    while (tokenizer.hasMoreTokens()) {
                        String result = tokenizer.nextToken().replaceAll("\\s*", "");
                        if (result == null || result.equals("")) continue;
                        out.collect((Object)result);
                    }
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }
}

