/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.windowing;

import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.function.source.SourceFunction;
import org.apache.flink.streaming.api.windowing.deltafunction.DeltaFunction;
import org.apache.flink.streaming.api.windowing.deltafunction.EuclideanDistance;
import org.apache.flink.streaming.api.windowing.extractor.Extractor;
import org.apache.flink.streaming.api.windowing.extractor.FieldsFromTuple;
import org.apache.flink.streaming.api.windowing.helper.Count;
import org.apache.flink.streaming.api.windowing.helper.Delta;
import org.apache.flink.streaming.api.windowing.helper.WindowingHelper;
import org.apache.flink.util.Collector;

public class DeltaExtractExample {
    private static boolean fileOutput = false;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!DeltaExtractExample.parseParameters(args)) {
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        SingleOutputStreamOperator dstream = env.addSource((SourceFunction)new CountingSource()).window(new WindowingHelper[]{Delta.of((double)1.2, (DeltaFunction)new EuclideanDistance((Extractor)new FieldsFromTuple(new int[]{0, 1})), (Object)new Tuple3((Object)0.0, (Object)0.0, (Object)"foo"))}).every(new WindowingHelper[]{Count.of((int)2)}).reduce((ReduceFunction)new ConcatStrings());
        if (fileOutput) {
            dstream.writeAsText(outputPath, 1L);
        } else {
            dstream.print();
        }
        env.execute("Delta Extract Example");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing DeltaExtractExample with generated data.");
            System.out.println("  Provide parameter to write to file.");
            System.out.println("  Usage: DeltaExtractExample <result path>");
            return true;
        }
        fileOutput = true;
        if (args.length == 1) {
            outputPath = args[0];
            return true;
        }
        System.err.println("Usage: DeltaExtractExample <result path>");
        return false;
    }

    private static final class ConcatStrings
    implements ReduceFunction<Tuple3<Double, Double, String>> {
        private static final long serialVersionUID = 1L;

        private ConcatStrings() {
        }

        public Tuple3<Double, Double, String> reduce(Tuple3<Double, Double, String> value1, Tuple3<Double, Double, String> value2) throws Exception {
            return new Tuple3(value1.f0, value2.f1, (Object)((String)value1.f2 + "|" + (String)value2.f2));
        }
    }

    private static class CountingSource
    implements SourceFunction<Tuple3<Double, Double, String>> {
        private static final long serialVersionUID = 1L;
        private int counter = 0;

        private CountingSource() {
        }

        public void invoke(Collector<Tuple3<Double, Double, String>> collector) throws Exception {
            while (true) {
                if (this.counter > 9999) {
                    this.counter = 0;
                }
                collector.collect((Object)new Tuple3((Object)this.counter, (Object)((double)this.counter + 1.0), (Object)("V" + this.counter++)));
            }
        }
    }
}

