/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.wordcount;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.examples.java.wordcount.util.WordCountData;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.util.Collector;

public class PojoExample {
    private static boolean fileOutput = false;
    private static String textPath;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!PojoExample.parseParameters(args)) {
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStream<String> text = PojoExample.getTextDataStream(env);
        SingleOutputStreamOperator counts = text.flatMap((FlatMapFunction)new Tokenizer()).keyBy(new String[]{"word"}).sum("frequency");
        if (fileOutput) {
            counts.writeAsText(outputPath);
        } else {
            counts.print();
        }
        env.execute("WordCount Pojo Example");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing PojoExample example with built-in default data.");
            System.out.println("  Provide parameters to read input data from a file.");
            System.out.println("  Usage: PojoExample <text path> <result path>");
            return true;
        }
        fileOutput = true;
        if (args.length == 2) {
            textPath = args[0];
            outputPath = args[1];
            return true;
        }
        System.err.println("Usage: PojoExample <text path> <result path>");
        return false;
    }

    private static DataStream<String> getTextDataStream(StreamExecutionEnvironment env) {
        if (fileOutput) {
            return env.readTextFile(textPath);
        }
        return env.fromElements((Object[])WordCountData.WORDS);
    }

    public static final class Tokenizer
    implements FlatMapFunction<String, Word> {
        private static final long serialVersionUID = 1L;

        public void flatMap(String value, Collector<Word> out) {
            String[] tokens;
            for (String token : tokens = value.toLowerCase().split("\\W+")) {
                if (token.length() <= 0) continue;
                out.collect((Object)new Word(token, 1));
            }
        }
    }

    public static class Word {
        private String word;
        private Integer frequency;

        public Word() {
        }

        public Word(String word, int i) {
            this.word = word;
            this.frequency = i;
        }

        public String getWord() {
            return this.word;
        }

        public void setWord(String word) {
            this.word = word;
        }

        public Integer getFrequency() {
            return this.frequency;
        }

        public void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        public String toString() {
            return "(" + this.word + "," + this.frequency + ")";
        }
    }
}

