/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.scala.examples.windowing;

import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.windowing.delta.DeltaFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.windowing.assigners.GlobalWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.evictors.TimeEvictor;
import org.apache.flink.streaming.api.windowing.time.AbstractTime;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.DeltaTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.scala.examples.windowing.TopSpeedWindowing;
import org.apache.flink.streaming.scala.examples.windowing.TopSpeedWindowing$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class TopSpeedWindowing$ {
    public static final TopSpeedWindowing$ MODULE$;
    private final int numOfCars;
    private final int evictionSec;
    private final double triggerMeters;
    private boolean fileInput;
    private boolean fileOutput;
    private String inputPath;
    private String outputPath;

    static {
        new TopSpeedWindowing$();
    }

    public int numOfCars() {
        return this.numOfCars;
    }

    public int evictionSec() {
        return this.evictionSec;
    }

    public double triggerMeters() {
        return this.triggerMeters;
    }

    public void main(String[] args) {
        if (this.parseParameters(args)) {
            StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
            env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
            env.setParallelism(1);
            DataStream<TopSpeedWindowing.CarEvent> cars = this.setCarsInput(env);
            DataStream topSeed = cars.assignAscendingTimestamps((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(TopSpeedWindowing.CarEvent x$1) {
                    return x$1.time();
                }
            }).keyBy("carId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).window((WindowAssigner)GlobalWindows.create()).evictor((Evictor)TimeEvictor.of((AbstractTime)Time.of((long)(this.evictionSec() * 1000), (TimeUnit)TimeUnit.MILLISECONDS))).trigger((Trigger)DeltaTrigger.of((double)this.triggerMeters(), (DeltaFunction)new DeltaFunction<TopSpeedWindowing.CarEvent>(){

                public double getDelta(TopSpeedWindowing.CarEvent oldSp, TopSpeedWindowing.CarEvent newSp) {
                    return newSp.distance() - oldSp.distance();
                }
            })).maxBy("speed");
            DataStreamSink dataStreamSink = this.fileOutput() ? topSeed.writeAsText(this.outputPath(), topSeed.writeAsText$default$2()) : topSeed.print();
            env.execute("TopSpeedWindowing");
            return;
        }
    }

    public Stream<TopSpeedWindowing.CarEvent> genCarStream() {
        return this.org$apache$flink$streaming$scala$examples$windowing$TopSpeedWindowing$$carStream$1((Stream)((Stream)scala.package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)this.numOfCars()), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TopSpeedWindowing.CarEvent apply(int x$2) {
                return new TopSpeedWindowing.CarEvent(x$2, 50, 0.0, System.currentTimeMillis());
            }
        }, scala.package$.MODULE$.Stream().canBuildFrom()));
    }

    public Tuple4<Object, Object, Object, Object> parseMap(String line) {
        String[] record = line.substring(1, line.length() - 1).split(",");
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(record[0])).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(record[1])).toInt()), (Object)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(record[2])).toDouble()), (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(record[3])).toLong()));
    }

    public boolean fileInput() {
        return this.fileInput;
    }

    public void fileInput_$eq(boolean x$1) {
        this.fileInput = x$1;
    }

    public boolean fileOutput() {
        return this.fileOutput;
    }

    public void fileOutput_$eq(boolean x$1) {
        this.fileOutput = x$1;
    }

    public String inputPath() {
        return this.inputPath;
    }

    public void inputPath_$eq(String x$1) {
        this.inputPath = x$1;
    }

    public String outputPath() {
        return this.outputPath;
    }

    public void outputPath_$eq(String x$1) {
        this.outputPath = x$1;
    }

    public boolean parseParameters(String[] args) {
        boolean bl;
        if (args.length > 0) {
            if (args.length == 2) {
                this.fileInput_$eq(true);
                this.fileOutput_$eq(true);
                this.inputPath_$eq(args[0]);
                this.outputPath_$eq(args[1]);
                bl = true;
            } else {
                System.err.println("Usage: TopSpeedWindowing <input path> <output path>");
                bl = false;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private DataStream<TopSpeedWindowing.CarEvent> setCarsInput(StreamExecutionEnvironment env) {
        return this.fileInput() ? env.readTextFile(this.inputPath()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple4<Object, Object, Object, Object> apply(String x$3) {
                return TopSpeedWindowing$.MODULE$.parseMap(x$3);
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, Object, Object>>(){

            public TypeInformation<?>[] protected$types(anon.4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.4 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                return new CaseClassSerializer<Tuple4<Object, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(Tuple4.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TopSpeedWindowing.CarEvent apply(Tuple4<Object, Object, Object, Object> x) {
                return new TopSpeedWindowing.CarEvent(BoxesRunTime.unboxToInt((Object)x._1()), BoxesRunTime.unboxToInt((Object)x._2()), BoxesRunTime.unboxToDouble((Object)x._3()), BoxesRunTime.unboxToLong((Object)x._4()));
            }
        }, (TypeInformation)new CaseClassTypeInfo<TopSpeedWindowing.CarEvent>(){

            public TypeInformation<?>[] protected$types(anon.5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<TopSpeedWindowing.CarEvent> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.5 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                return new CaseClassSerializer<TopSpeedWindowing.CarEvent>(this, fieldSerializers){

                    public TopSpeedWindowing.CarEvent createInstance(Object[] fields) {
                        return new TopSpeedWindowing.CarEvent(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]), BoxesRunTime.unboxToLong((Object)fields[3]));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(TopSpeedWindowing.CarEvent.class)) : env.fromCollection(this.genCarStream(), ClassTag$.MODULE$.apply(TopSpeedWindowing.CarEvent.class), (TypeInformation)new CaseClassTypeInfo<TopSpeedWindowing.CarEvent>(){

            public TypeInformation<?>[] protected$types(anon.6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<TopSpeedWindowing.CarEvent> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.6 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                return new CaseClassSerializer<TopSpeedWindowing.CarEvent>(this, fieldSerializers){

                    public TopSpeedWindowing.CarEvent createInstance(Object[] fields) {
                        return new TopSpeedWindowing.CarEvent(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]), BoxesRunTime.unboxToLong((Object)fields[3]));
                    }
                };
            }
        });
    }

    public final TopSpeedWindowing.CarEvent org$apache$flink$streaming$scala$examples$windowing$TopSpeedWindowing$$nextSpeed$1(TopSpeedWindowing.CarEvent carEvent) {
        int next = Random$.MODULE$.nextBoolean() ? package$.MODULE$.min(100, carEvent.speed() + 5) : package$.MODULE$.max(0, carEvent.speed() - 5);
        return new TopSpeedWindowing.CarEvent(carEvent.carId(), next, carEvent.distance() + (double)next / 3.6, System.currentTimeMillis());
    }

    public final Stream org$apache$flink$streaming$scala$examples$windowing$TopSpeedWindowing$$carStream$1(Stream speeds) {
        Thread.sleep(1000L);
        return speeds.append((Function0)new Serializable(speeds){
            public static final long serialVersionUID = 0L;
            private final Stream speeds$1;

            public final Stream<TopSpeedWindowing.CarEvent> apply() {
                return TopSpeedWindowing$.MODULE$.org$apache$flink$streaming$scala$examples$windowing$TopSpeedWindowing$$carStream$1((Stream)this.speeds$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TopSpeedWindowing.CarEvent apply(TopSpeedWindowing.CarEvent carEvent) {
                        return TopSpeedWindowing$.MODULE$.org$apache$flink$streaming$scala$examples$windowing$TopSpeedWindowing$$nextSpeed$1(carEvent);
                    }
                }, scala.package$.MODULE$.Stream().canBuildFrom()));
            }
            {
                this.speeds$1 = speeds$1;
            }
        });
    }

    private TopSpeedWindowing$() {
        MODULE$ = this;
        this.numOfCars = 2;
        this.evictionSec = 10;
        this.triggerMeters = 50.0;
        this.fileInput = false;
        this.fileOutput = false;
        this.inputPath = null;
        this.outputPath = null;
    }
}

