/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.streaming.api.windowing.helper;

import java.io.Serializable;

public class TimestampWrapper<T> implements Serializable {

	private static final long serialVersionUID = 1L;
	private long startTime;
	private Timestamp<T> timestamp;

	public TimestampWrapper(Timestamp<T> timeStamp, long startTime) {
		this.timestamp = timeStamp;
		this.startTime = startTime;
	}

	public long getTimestamp(T in) {
		return timestamp.getTimestamp(in);
	}

	public long getStartTime() {
		return startTime;
	}

	public boolean isDefaultTimestamp() {
		return timestamp instanceof SystemTimestamp;
	}

	@Override
	public boolean equals(Object other) {
		if (other == null || !(other instanceof TimestampWrapper)) {
			return false;
		} else {
			try {
				@SuppressWarnings("unchecked")
				TimestampWrapper<T> otherTSW = (TimestampWrapper<T>) other;
				if (timestamp instanceof SystemTimestamp
						&& otherTSW.timestamp instanceof SystemTimestamp) {
					return true;
				} else {
					return startTime == otherTSW.startTime
							&& timestamp.getClass() == otherTSW.timestamp.getClass();
				}
			} catch (ClassCastException e) {
				return false;
			}
		}
	}
}
