/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.StreamConfig;
import org.apache.flink.streaming.api.invokable.StreamInvokable;
import org.apache.flink.streaming.api.streamrecord.StreamRecord;
import org.apache.flink.streaming.api.streamrecord.StreamRecordSerializer;
import org.apache.flink.streaming.api.streamvertex.StreamTaskContext;
import org.apache.flink.streaming.io.CoReaderIterator;
import org.apache.flink.streaming.util.MockCollector;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public class MockContext<IN, OUT>
implements StreamTaskContext<OUT> {
    private Collection<IN> inputs;
    private List<OUT> outputs;
    private Collector<OUT> collector;
    private StreamRecordSerializer<IN> inDeserializer;
    private MutableObjectIterator<StreamRecord<IN>> iterator;

    public MockContext(Collection<IN> inputs) {
        this.inputs = inputs;
        if (inputs.isEmpty()) {
            throw new RuntimeException("Inputs must not be empty");
        }
        TypeInformation inTypeInfo = TypeExtractor.getForObject(inputs.iterator().next());
        this.inDeserializer = new StreamRecordSerializer(inTypeInfo);
        this.iterator = new MockInputIterator();
        this.outputs = new ArrayList<OUT>();
        this.collector = new MockCollector<OUT>(this.outputs);
    }

    public List<OUT> getOutputs() {
        return this.outputs;
    }

    public Collector<OUT> getCollector() {
        return this.collector;
    }

    public StreamRecordSerializer<IN> getInDeserializer() {
        return this.inDeserializer;
    }

    public MutableObjectIterator<StreamRecord<IN>> getIterator() {
        return this.iterator;
    }

    public static <IN, OUT> List<OUT> createAndExecute(StreamInvokable<IN, OUT> invokable, List<IN> inputs) {
        MockContext<IN, OUT> mockContext = new MockContext<IN, OUT>(inputs);
        invokable.setup(mockContext);
        try {
            invokable.open(null);
            invokable.invoke();
            invokable.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot invoke invokable.", e);
        }
        return mockContext.getOutputs();
    }

    public StreamConfig getConfig() {
        return null;
    }

    public ClassLoader getUserCodeClassLoader() {
        return null;
    }

    public <X> MutableObjectIterator<X> getInput(int index) {
        if (index == 0) {
            return this.iterator;
        }
        throw new IllegalArgumentException("There is only 1 input");
    }

    public <X> StreamRecordSerializer<X> getInputSerializer(int index) {
        if (index == 0) {
            return this.inDeserializer;
        }
        throw new IllegalArgumentException("There is only 1 input");
    }

    public Collector<OUT> getOutputCollector() {
        return this.collector;
    }

    public <X, Y> CoReaderIterator<X, Y> getCoReader() {
        throw new IllegalArgumentException("CoReader not available");
    }

    private class MockInputIterator
    implements MutableObjectIterator<StreamRecord<IN>> {
        Iterator<IN> listIterator;

        public MockInputIterator() {
            this.listIterator = MockContext.this.inputs.iterator();
        }

        public StreamRecord<IN> next(StreamRecord<IN> reuse) throws IOException {
            if (this.listIterator.hasNext()) {
                reuse.setObject(this.listIterator.next());
            } else {
                reuse = null;
            }
            return reuse;
        }
    }
}

